/*
 * Decompiled with CFR 0.152.
 */
package fabric.fun.qu_an.minecraft.asyncparticles.client.mixin_extension;

import com.bawnorton.mixinsquared.ext.ExtensionRegistrar;
import fabric.fun.qu_an.minecraft.asyncparticles.client.mixin_extension.MixinUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.CopyOnWriteArrayList;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.logging.ILogger;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.transformer.ext.IExtension;
import org.spongepowered.asm.mixin.transformer.ext.ITargetClassContext;
import org.spongepowered.asm.service.MixinService;

public final class ExtensionCancelMixinMethod
implements IExtension {
    private static final ILogger LOGGER = MixinService.getService().getLogger("asyncparticles:mixin_method_canceller");
    private static final List<Canceller> CANCELLERS = new CopyOnWriteArrayList<Canceller>();
    private static boolean init;

    public static void init() {
        if (!init) {
            ExtensionRegistrar.register((IExtension)new ExtensionCancelMixinMethod());
            init = true;
        }
    }

    public static void register(Canceller canceller) {
        CANCELLERS.add(canceller);
    }

    private ExtensionCancelMixinMethod() {
    }

    public boolean checkActive(MixinEnvironment environment) {
        return true;
    }

    public void preApply(ITargetClassContext context) {
        if (CANCELLERS.isEmpty()) {
            return;
        }
        MixinUtils.tryAs(context).ifPresent(contextExtension -> {
            SortedSet mixins = contextExtension.getMixins();
            mixins.forEach(mixin -> {
                String mixinClassName = mixin.getClassName();
                ArrayList<Canceller> cancellers = null;
                for (Canceller canceller : CANCELLERS) {
                    if (!canceller.preTest(mixinClassName)) continue;
                    if (cancellers == null) {
                        cancellers = new ArrayList<Canceller>(CANCELLERS.size());
                    }
                    cancellers.add(canceller);
                }
                if (cancellers == null) {
                    return;
                }
                ClassNode classNode = MixinUtils.getDirectClassNode(mixin);
                List mixinMethods = classNode.methods;
                if (mixinMethods == null || mixinMethods.isEmpty()) {
                    return;
                }
                Iterator iterator = mixinMethods.iterator();
                block1: while (iterator.hasNext()) {
                    List<String> parameterNames;
                    MethodNode method = (MethodNode)iterator.next();
                    if (method.parameters == null || method.parameters.isEmpty()) {
                        parameterNames = Collections.emptyList();
                    } else {
                        parameterNames = new ArrayList(method.parameters.size());
                        method.parameters.forEach(parameter -> parameterNames.add(parameter.name));
                    }
                    for (Canceller canceller : cancellers) {
                        if (!canceller.test(mixinClassName, method.name, method.desc, parameterNames)) continue;
                        iterator.remove();
                        LOGGER.warn("Cancelled mixin method {}#{}", new Object[]{mixinClassName, method.desc});
                        continue block1;
                    }
                }
            });
        });
    }

    public void postApply(ITargetClassContext context) {
    }

    public void export(MixinEnvironment env, String name, boolean force, ClassNode classNode) {
    }

    public static interface Canceller {
        public boolean preTest(String var1);

        public boolean test(String var1, String var2, String var3, List<String> var4);
    }
}

