/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.logging.LogUtils;
import dev.architectury.injectables.annotations.ExpectPlatform;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.AsyncTicker;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleAddon;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.compat.ModListHelper;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.config.SimplePropertiesConfig;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.neoforge.AsyncRendererImpl;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.BindingTesselator;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionTracker;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionUtil;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.FakeBeginTesselator;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.fantastic.ParticleRenderingPhase;
import net.irisshaders.iris.fantastic.PhasedParticleEngine;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.irisshaders.iris.shaderpack.properties.ParticleRenderingSettings;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ItemPickupParticle;
import net.minecraft.client.particle.MobAppearanceParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class AsyncRenderer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Set<Class<? extends Particle>> SYNC_PARTICLE_TYPES = Collections.newSetFromMap(new IdentityHashMap());
    private static final Map<ParticleRenderType, Set<Particle>> SYNC_PARTICLES;
    public static final ForkJoinPool EXECUTOR;
    public static final String THREAD_PREFIX = "AsyncParticleRenderer";
    public static Frustum frustum;
    private static Consumer<String> debugConsumer;
    private static CompletableFuture<Void> asyncTask;
    private static boolean mixedParticleRenderingSetting;
    private static int asyncTasksSize;
    private static final ExceptionTracker<Class<? extends Particle>> EXCEPTION_TRACKER;
    private static final Map<ParticleRenderType, BindingTesselator> BTESSELATORS;

    private static void addSyncByClassName(String className) {
        try {
            SYNC_PARTICLE_TYPES.add(Class.forName(className));
        }
        catch (Exception e) {
            LOGGER.warn("", (Throwable)e);
        }
    }

    public static void start(float f, Camera camera) {
        Minecraft mc = Minecraft.getInstance();
        ProfilerFiller profiler = mc.getProfiler();
        profiler.popPush("async_particles");
        AsyncRenderer.tryDebug();
        AsyncRenderer.clearSync();
        AsyncRenderer.captureParticleRenderingSetting();
        profiler.push("render_async");
        ParticleEngine particleEngine = mc.particleEngine;
        TextureManager textureManager = particleEngine.textureManager;
        ObjectArrayList asyncTasks = new ObjectArrayList(asyncTasksSize);
        for (ParticleRenderType particleRenderType : ModListHelper.IS_FORGE ? particleEngine.particles.keySet() : ParticleEngine.RENDER_ORDER) {
            Queue queue;
            if (particleRenderType == ParticleRenderType.NO_RENDER || (queue = (Queue)particleEngine.particles.get(particleRenderType)) == null || queue.isEmpty()) continue;
            BindingTesselator bTesselator = AsyncRenderer.getBTesselator(particleRenderType, textureManager);
            if (bTesselator.shouldSync) continue;
            asyncTasks.add((Object)CompletableFuture.runAsync(() -> AsyncRenderer.renderParticles(f, camera, queue, particleRenderType, bTesselator.begin()), EXECUTOR).exceptionally(AsyncRenderer::renderAsyncExceptionally));
        }
        int size = asyncTasksSize = asyncTasks.size();
        asyncTask = CompletableFuture.allOf((CompletableFuture[])asyncTasks.toArray((Object[])new CompletableFuture[size]));
        profiler.pop();
    }

    private static void renderParticles(float f, Camera camera, Queue<Particle> particles, ParticleRenderType particleRenderType, BufferBuilder bufferBuilder) {
        Frustum frustum = AsyncRenderer.frustum;
        float f2 = f + 1.0f;
        for (Particle particle : particles) {
            float f3;
            if (!particle.isAlive()) continue;
            float f4 = f3 = ((ParticleAddon)particle).asyncparticles$isTicked() ? f : f2;
            if (SimplePropertiesConfig.isCullParticles() && !frustum.isVisible(((ParticleAddon)particle).getRenderBoundingBox(f3))) continue;
            if (((ParticleAddon)particle).asyncparticles$isRenderSync()) {
                AsyncRenderer.recordSync(particleRenderType, particle);
                continue;
            }
            try {
                particle.render((VertexConsumer)bufferBuilder, camera, f3);
            }
            catch (Throwable t) {
                boolean tolerable = AsyncTicker.isTolerable(t);
                if (tolerable && !EXCEPTION_TRACKER.addException(particle.getClass(), t)) continue;
                ((ParticleAddon)particle).asyncparticles$setRenderSync();
                if (!AsyncRenderer.shouldSync(particle.getClass())) {
                    if (!tolerable) {
                        LOGGER.warn("Exception while rendering particle {}, marking as sync", (Object)particle, (Object)t);
                    } else {
                        LOGGER.warn("Exception {} thrown while rendering particle {} exceeds the threshold, please contact the author: {}", new Object[]{t.getClass().getSimpleName(), particle, "https://github.com/Harveykang/AsyncParticles/issues"});
                        LOGGER.warn("", t);
                    }
                    AsyncRenderer.markAsSync(particle.getClass());
                }
                AsyncRenderer.recordSync(particleRenderType, particle);
            }
        }
    }

    private static Void renderAsyncExceptionally(Throwable e) {
        LOGGER.error("Error rendering particle", e);
        Minecraft mc1 = Minecraft.getInstance();
        if (mc1.level != null && mc1.player != null) {
            throw ExceptionUtil.toThrowDirectly(e);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void irisOpaque(float f, Camera camera, LightTexture lightTexture, Predicate<ParticleRenderType> predicate) {
        void var3_3;
        void var2_2;
        void var1_1;
        AsyncRendererImpl.irisOpaque(f, (Camera)var1_1, (LightTexture)var2_2, (Predicate<ParticleRenderType>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void irisTranslucent(float f, Camera camera, LightTexture lightTexture, Predicate<ParticleRenderType> predicate) {
        void var3_3;
        void var2_2;
        void var1_1;
        AsyncRendererImpl.irisTranslucent(f, (Camera)var1_1, (LightTexture)var2_2, (Predicate<ParticleRenderType>)var3_3);
    }

    public static void join(float f, Camera camera, LightTexture lightTexture) {
        if (AsyncRenderer.isMixedParticleRenderingSetting()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        ProfilerFiller profiler = mc.getProfiler();
        profiler.popPush("async_particles");
        LevelRenderer levelRenderer = mc.levelRenderer;
        if (levelRenderer.transparencyChain != null) {
            RenderTarget particlesTarget = levelRenderer.getParticlesTarget();
            particlesTarget.clear(Minecraft.ON_OSX);
            particlesTarget.copyDepthFrom(mc.getMainRenderTarget());
            RenderStateShard.PARTICLES_TARGET.setupRenderState();
        }
        profiler.push("wait_for_async_tasks");
        AsyncRenderer.waitForAsyncTasks();
        profiler.pop();
        ParticleEngine particleEngine = mc.particleEngine;
        if (ModListHelper.FABRIC_IRIS_LOADED) {
            ((PhasedParticleEngine)particleEngine).setParticleRenderingPhase(ParticleRenderingPhase.EVERYTHING);
        }
        particleEngine.render(lightTexture, camera, f);
        if (levelRenderer.transparencyChain != null) {
            RenderStateShard.PARTICLES_TARGET.clearRenderState();
        }
    }

    public static void waitForAsyncTasks() {
        if (asyncTask != null) {
            asyncTask.join();
            asyncTask = null;
        }
    }

    public static ReportedException constructCrashReport(Particle particle, ParticleRenderType particleRenderType, Throwable t) {
        AsyncTicker.debugLater(arg_0 -> ((Logger)LOGGER).info(arg_0));
        AsyncTicker.tryDebug();
        AsyncRenderer.debugLater(arg_0 -> ((Logger)LOGGER).info(arg_0));
        AsyncRenderer.tryDebug();
        CrashReport crashReport = CrashReport.forThrowable((Throwable)t, (String)"Rendering Particle");
        CrashReportCategory crashReportCategory = crashReport.addCategory("Particle being rendered");
        crashReportCategory.setDetail("Particle", () -> ((Particle)particle).toString());
        crashReportCategory.setDetail("Particle Type", () -> ((ParticleRenderType)particleRenderType).toString());
        return new ReportedException(crashReport);
    }

    private static void captureParticleRenderingSetting() {
        if (ModListHelper.IRIS_LIKE_LOADED) {
            mixedParticleRenderingSetting = Iris.isPackInUseQuick() && AsyncRenderer.getParticleRenderingSettings0() == ParticleRenderingSettings.MIXED;
        }
    }

    public static boolean isMixedParticleRenderingSetting() {
        return mixedParticleRenderingSetting;
    }

    private static ParticleRenderingSettings getParticleRenderingSettings0() {
        if (!Iris.isPackInUseQuick()) {
            return ParticleRenderingSettings.UNSET;
        }
        return Iris.getPipelineManager().getPipeline().map(WorldRenderingPipeline::getParticleRenderingSettings).orElse(ParticleRenderingSettings.MIXED);
    }

    private static void resetBTesselators() {
        BTESSELATORS.values().forEach(BindingTesselator::clear);
    }

    private static void closeBTesselators() {
        Iterator<BindingTesselator> iterator = BTESSELATORS.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().close();
            iterator.remove();
        }
    }

    public static BindingTesselator getBTesselator(ParticleRenderType particleRenderType, TextureManager textureManager) {
        return BTESSELATORS.computeIfAbsent(particleRenderType, k -> AsyncRenderer.computeBTesselator(k, textureManager));
    }

    @NotNull
    private static BindingTesselator computeBTesselator(ParticleRenderType particleRenderType, TextureManager textureManager) {
        FakeBeginTesselator fakeBeginTesselator = FakeBeginTesselator.newFakeBeginTesselator();
        BufferBuilder builder = particleRenderType.begin((Tesselator)fakeBeginTesselator, textureManager);
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        RenderSystem.defaultBlendFunc();
        if (builder == null) {
            return BindingTesselator.EMPTY;
        }
        VertexFormat.Mode mode = fakeBeginTesselator.getMode();
        VertexFormat format = fakeBeginTesselator.getFormat();
        if (mode == null || format == null) {
            return BindingTesselator.EMPTY;
        }
        return new BindingTesselator(256, mode, format, particleRenderType == ParticleRenderType.CUSTOM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markAsSync(Class<? extends Particle> aClass) {
        Set<Class<? extends Particle>> set = SYNC_PARTICLE_TYPES;
        synchronized (set) {
            SYNC_PARTICLE_TYPES.add(aClass);
        }
    }

    public static boolean shouldSync(Class<? extends Particle> aClass) {
        return SYNC_PARTICLE_TYPES.contains(aClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recordSync(ParticleRenderType particleRenderType, Particle particle) {
        Set particles;
        Set set = particles = SYNC_PARTICLES.computeIfAbsent(particleRenderType, k -> Collections.newSetFromMap(new IdentityHashMap()));
        synchronized (set) {
            particles.add(particle);
        }
    }

    public static Set<Particle> getSync(ParticleRenderType particleRenderType) {
        Set<Particle> set = SYNC_PARTICLES.get(particleRenderType);
        return set == null ? Collections.emptySet() : set;
    }

    private static void clearSync() {
        SYNC_PARTICLES.clear();
    }

    public static void debugLater(Consumer<String> consumer) {
        debugConsumer = consumer;
    }

    static void tryDebug() {
        if (debugConsumer != null) {
            debugConsumer.accept("[Debug AsyncRenderer]\nasync queue size: %d,\nbuffer capacity: %s,\nrender order: %s,\nsync particle count: %d,\nsync particle types: %s,\nsync particle render types: %s,\niris particle state: %s".formatted(asyncTasksSize, BTESSELATORS.entrySet().stream().filter(e -> !((BindingTesselator)e.getValue()).shouldSync).collect(Collectors.toMap(Map.Entry::getKey, e -> ((BindingTesselator)e.getValue()).buffer.capacity)), ModListHelper.IS_FORGE ? Minecraft.getInstance().particleEngine.particles.keySet() : ParticleEngine.RENDER_ORDER, SYNC_PARTICLES.values().stream().mapToInt(Set::size).sum(), SYNC_PARTICLE_TYPES.stream().map(Class::getName).toList(), BTESSELATORS.entrySet().stream().filter(e -> ((BindingTesselator)e.getValue()).shouldSync).map(Map.Entry::getKey).toList(), ModListHelper.IRIS_LIKE_LOADED && Iris.isPackInUseQuick() ? AsyncRenderer.getParticleRenderingSettings0().name() : "disabled"));
            debugConsumer = null;
        }
    }

    public static void reset() {
        AsyncRenderer.waitForAsyncTasks();
        AsyncRenderer.closeBTesselators();
        AsyncRenderer.clearSync();
    }

    static {
        SYNC_PARTICLE_TYPES.add(ItemPickupParticle.class);
        SYNC_PARTICLE_TYPES.add(MobAppearanceParticle.class);
        if (ModListHelper.DUMMMMMMY_LOADED) {
            AsyncRenderer.addSyncByClassName("net.mehvahdjukaar.dummmmmmy.client.DamageNumberParticle");
        }
        if (ModListHelper.FABRIC_EFFECTIVE_LOADED) {
            AsyncRenderer.addSyncByClassName("org.ladysnake.effective.particle.SplashParticle");
        }
        if (ModListHelper.FORGE_EFFECTIVE_LOADED) {
            AsyncRenderer.addSyncByClassName("concerrox.effective.particle.SplashParticle");
        }
        if (ModListHelper.TOMBSTONE_LOADED) {
            AsyncRenderer.addSyncByClassName("ovh.corail.tombstone.particle.ParticleCasting");
            AsyncRenderer.addSyncByClassName("ovh.corail.tombstone.particle.ParticleGhost");
            AsyncRenderer.addSyncByClassName("ovh.corail.tombstone.particle.ParticleGraveSoul");
            AsyncRenderer.addSyncByClassName("ovh.corail.tombstone.particle.ParticleMagicCircle");
            AsyncRenderer.addSyncByClassName("ovh.corail.tombstone.particle.ParticleMarker");
            AsyncRenderer.addSyncByClassName("ovh.corail.tombstone.particle.ParticleRounding");
        }
        SYNC_PARTICLES = Collections.synchronizedMap(new IdentityHashMap());
        AtomicInteger workerCount = new AtomicInteger(1);
        int clamp = Mth.clamp((int)(Runtime.getRuntime().availableProcessors() - 1), (int)1, (int)6);
        EXECUTOR = new ForkJoinPool(clamp, forkJoinPool -> {
            ForkJoinWorkerThread forkJoinWorkerThread = new ForkJoinWorkerThread(forkJoinPool){

                @Override
                protected void onTermination(Throwable throwable) {
                    if (throwable != null) {
                        LOGGER.warn("{} died", (Object)this.getName(), (Object)throwable);
                    } else {
                        LOGGER.debug("{} shutdown", (Object)this.getName());
                    }
                    super.onTermination(throwable);
                }
            };
            forkJoinWorkerThread.setName("AsyncParticleRenderer-" + workerCount.getAndIncrement());
            forkJoinWorkerThread.setDaemon(true);
            return forkJoinWorkerThread;
        }, Util::onThreadException, true);
        mixedParticleRenderingSetting = false;
        EXCEPTION_TRACKER = new ExceptionTracker(() -> 5000, () -> SimplePropertiesConfig.renderFailurePerSecondThreshold);
        BTESSELATORS = new ConcurrentHashMap<ParticleRenderType, BindingTesselator>();
    }
}

