/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client.compat.create.neoforge;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ContraptionCollider;
import com.simibubi.create.content.contraptions.ContraptionHandler;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.foundation.collision.Matrix3d;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.mixin.neoforge.create.InvokerContraptionCollider;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;

public class CreateUtilImpl {
    public static Collection<WeakReference<AbstractContraptionEntity>> contraptions(LevelAccessor level) {
        return CreateUtilImpl.loadedContraptions(level).values();
    }

    @Nullable
    public static Vec3 collideMotionWithContraptions(ClientLevel level, Vec3 motion, AABB bounds) {
        Vector3d result = new Vector3d(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        AABB finalBounds = bounds.inflate(0.1);
        CreateUtilImpl.forEachContraption((LevelAccessor)level, contraptionEntity -> {
            Vec3 vec3 = CreateUtilImpl.collideMotionWithContraption(level, motion, finalBounds, contraptionEntity);
            if (vec3 != null) {
                result.set(Math.abs(result.x) < Math.abs(vec3.x) ? result.x : vec3.x, Math.abs(result.y) < Math.abs(vec3.y) ? result.y : vec3.y, Math.abs(result.z) < Math.abs(vec3.z) ? result.z : vec3.z);
            }
            return true;
        });
        if (result.x == Double.MAX_VALUE || motion.x == result.x && motion.y == result.y && motion.z == result.z) {
            return null;
        }
        return new Vec3(result.x, result.y, result.z);
    }

    public static void forEachContraption(LevelAccessor level, Predicate<AbstractContraptionEntity> consumer) {
        try {
            for (WeakReference<AbstractContraptionEntity> r : CreateUtilImpl.contraptions(level)) {
                AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)r.get();
                if (contraptionEntity == null || !contraptionEntity.isAliveOrStale() || consumer.test(contraptionEntity)) continue;
                return;
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    public static Iterator<AbstractContraptionEntity> forEachContraption(LevelAccessor level) {
        final Iterator<WeakReference<AbstractContraptionEntity>> iterator = CreateUtilImpl.contraptions(level).iterator();
        return new Iterator<AbstractContraptionEntity>(){
            private AbstractContraptionEntity next;

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                while (iterator.hasNext()) {
                    try {
                        this.next = (AbstractContraptionEntity)((WeakReference)iterator.next()).get();
                    }
                    catch (ConcurrentModificationException ignored) {
                        return false;
                    }
                    if (this.next == null || !this.next.isAliveOrStale()) continue;
                }
                return this.next != null;
            }

            @Override
            public AbstractContraptionEntity next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                AbstractContraptionEntity result = this.next;
                this.next = null;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void forEachRemaining(Consumer<? super AbstractContraptionEntity> action) {
                while (this.hasNext()) {
                    action.accept((AbstractContraptionEntity)this.next);
                }
            }
        };
    }

    public static Vec3 getWorldToLocalTranslation(Vec3 entityCenter, Vec3 anchorVec, Matrix3d rotationMatrix, float yawOffset) {
        Vec3 position = ContraptionCollider.worldToLocalPos((Vec3)entityCenter, (Vec3)anchorVec, (Matrix3d)rotationMatrix, (float)yawOffset);
        return position.subtract(entityCenter);
    }

    public static boolean isCollideWithContraption(ClientLevel level, Vec3 originalMotion, AABB bounds, AbstractContraptionEntity contraptionEntity) {
        return CreateUtilImpl.isCollideWithContraption(level, originalMotion, bounds, contraptionEntity, false);
    }

    public static boolean isCollideWithContraption(ClientLevel level, Vec3 originalMotion, AABB entityBounds, AbstractContraptionEntity contraptionEntity, boolean estimate) {
        ArrayList collidableBBs;
        AABB entityBoundingBox;
        if (contraptionEntity instanceof CarriageContraptionEntity) {
            AABB bb0 = contraptionEntity.getBoundingBox();
            v0 = bb0.inflate(0.0, Math.max(Math.max(bb0.getXsize(), bb0.getZsize()) - bb0.getYsize() * 0.3, 0.0), 0.0);
        } else {
            v0 = entityBoundingBox = contraptionEntity.getBoundingBox();
        }
        if (!entityBounds.expandTowards(originalMotion).intersects(entityBoundingBox)) {
            return false;
        }
        AbstractContraptionEntity.ContraptionRotationState rotation = contraptionEntity.getRotationState();
        Matrix3d rotationMatrix = rotation.asMatrix();
        Vec3 center = entityBounds.getCenter();
        Vec3 entityPosition = entityBounds.getBottomCenter();
        float yawOffset = rotation.getYawOffset();
        Vec3 anchorVec = contraptionEntity.getAnchorVec();
        Vec3 toLocalTranslation = CreateUtilImpl.getWorldToLocalTranslation(center, anchorVec, rotationMatrix, yawOffset);
        Vec3 contactPointMotion = contraptionEntity.getContactPointMotion(entityPosition);
        Vec3 localMotion = rotationMatrix.transform(originalMotion.subtract(contactPointMotion));
        AABB localBB = entityBounds.move(toLocalTranslation).inflate(1.0E-7);
        Contraption contraption = contraptionEntity.getContraption();
        AABB localExpanded = localBB.expandTowards(localMotion);
        Optional collisionShapes = contraption.getSimplifiedEntityColliders();
        if (collisionShapes.isPresent()) {
            collidableBBs = (ArrayList)collisionShapes.get();
        } else {
            if (estimate) {
                return true;
            }
            List<VoxelShape> shapes = InvokerContraptionCollider.invoker_getPotentiallyCollidedShapes((Level)level, contraption, localExpanded);
            collidableBBs = new ArrayList();
            shapes.forEach(shape -> shape.forAllBoxes((d, e, f, g, h, i) -> collidableBBs.add(new AABB(d, e, f, g, h, i))));
        }
        for (AABB bb : collidableBBs) {
            if (!localExpanded.intersects(bb)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static Vec3 collideMotionWithContraption(ClientLevel level, Vec3 originalMotion, AABB bounds, AbstractContraptionEntity contraptionEntity) {
        return CreateUtilImpl.collideMotionWithContraption(level, originalMotion, bounds, contraptionEntity, false);
    }

    @Nullable
    public static Vec3 collideMotionWithContraption(ClientLevel level, Vec3 originalMotion, AABB entityBounds, AbstractContraptionEntity contraptionEntity, boolean estimate) {
        Vec3 clippedLocal;
        ArrayList collidableBBs;
        AABB entityBoundingBox;
        if (contraptionEntity instanceof CarriageContraptionEntity) {
            AABB bb0 = contraptionEntity.getBoundingBox();
            v0 = bb0.inflate(0.0, Math.max(Math.max(bb0.getXsize(), bb0.getZsize()) - bb0.getYsize() * 0.3, 0.0), 0.0);
        } else {
            v0 = entityBoundingBox = contraptionEntity.getBoundingBox();
        }
        if (!entityBounds.expandTowards(originalMotion).intersects(entityBoundingBox)) {
            return null;
        }
        AbstractContraptionEntity.ContraptionRotationState rotation = contraptionEntity.getRotationState();
        Matrix3d rotationMatrix = rotation.asMatrix();
        Vec3 center = entityBounds.getCenter();
        Vec3 entityPosition = entityBounds.getBottomCenter();
        float yawOffset = rotation.getYawOffset();
        Vec3 anchorVec = contraptionEntity.getAnchorVec();
        Vec3 toLocalTranslation = CreateUtilImpl.getWorldToLocalTranslation(center, anchorVec, rotationMatrix, yawOffset);
        Vec3 contactPointMotion = contraptionEntity.getContactPointMotion(entityPosition);
        Vec3 localMotion = rotationMatrix.transform(originalMotion.subtract(contactPointMotion));
        AABB localBB = entityBounds.move(toLocalTranslation).inflate(1.0E-7);
        Contraption contraption = contraptionEntity.getContraption();
        AABB localExpanded = localBB.expandTowards(localMotion);
        Optional collisionShapes = contraption.getSimplifiedEntityColliders();
        if (collisionShapes.isPresent()) {
            collidableBBs = (ArrayList)collisionShapes.get();
        } else {
            if (estimate) {
                return Vec3.ZERO;
            }
            List<VoxelShape> shapes = InvokerContraptionCollider.invoker_getPotentiallyCollidedShapes((Level)level, contraption, localExpanded);
            collidableBBs = new ArrayList();
            shapes.forEach(shape -> shape.forAllBoxes((d, e, f, g, h, i) -> collidableBBs.add(new AABB(d, e, f, g, h, i))));
        }
        Vec3 localCenter = localBB.getCenter();
        double cx = localMotion.x;
        double cy = localMotion.y;
        double cz = localMotion.z;
        double sx = 0.0;
        double sy = 0.0;
        double sz = 0.0;
        boolean squeezed = false;
        double localXsize = localBB.getXsize();
        double localYsize = localBB.getYsize();
        double localZsize = localBB.getZsize();
        for (AABB bb : collidableBBs) {
            Vec3 bbCenter;
            if (!localExpanded.intersects(bb)) continue;
            if (localBB.intersects(bb)) {
                bbCenter = bb.getCenter();
                squeezed = true;
                AABB intersect = localBB.intersect(bb);
                double intersectXsize = intersect.getXsize();
                double intersectYsize = intersect.getYsize();
                double intersectZsize = intersect.getZsize();
                Direction.Axis squeezedAxis = CreateUtilImpl.getSqueezedAxis(intersectXsize, intersectYsize, intersectZsize);
                switch (squeezedAxis) {
                    case X: {
                        sx = CreateUtilImpl.getSqueezed(localCenter.x, bbCenter.x, intersectXsize, sx);
                        break;
                    }
                    case Y: {
                        sy = CreateUtilImpl.getSqueezed(localCenter.y, bbCenter.y, intersectYsize, cy > 0.0 ? cy : sy);
                        break;
                    }
                    case Z: {
                        sz = CreateUtilImpl.getSqueezed(localCenter.z, bbCenter.z, intersectZsize, sz);
                    }
                }
                continue;
            }
            if (squeezed) continue;
            bbCenter = bb.getCenter();
            Vec3 relative = bbCenter.subtract(localCenter);
            double halfXsum = (bb.getXsize() + localXsize) * 0.5;
            double halfYsum = (bb.getYsize() + localYsize) * 0.5;
            double halfZsum = (bb.getZsize() + localZsize) * 0.5;
            Direction.Axis collidedAxis = CreateUtilImpl.getCollideAxis(halfXsum, halfYsum, halfZsum, relative);
            switch (collidedAxis) {
                case X: {
                    cx = CreateUtilImpl.getCollided(relative.x, halfXsum, cx);
                    break;
                }
                case Y: {
                    cy = CreateUtilImpl.getCollided(relative.y, halfYsum, cy);
                    break;
                }
                case Z: {
                    cz = CreateUtilImpl.getCollided(relative.z, halfZsum, cz);
                }
            }
        }
        if (squeezed) {
            clippedLocal = new Vec3(sx, sy, sz);
        } else {
            clippedLocal = new Vec3(cx, cy, cz);
            if (localMotion.equals((Object)clippedLocal)) {
                return null;
            }
        }
        Vec3 clipped = rotationMatrix.transpose().transform(clippedLocal);
        double x = Math.signum(contactPointMotion.x) != Math.signum(originalMotion.x) || Math.abs(clipped.x) < Math.abs(contactPointMotion.x) ? contactPointMotion.x * 3.0 : contactPointMotion.x;
        double y = Math.signum(contactPointMotion.y) != Math.signum(originalMotion.y) || Math.abs(clipped.y) < Math.abs(contactPointMotion.y) ? contactPointMotion.y * 3.0 : contactPointMotion.y;
        double z = Math.signum(contactPointMotion.z) != Math.signum(originalMotion.z) || Math.abs(clipped.z) < Math.abs(contactPointMotion.z) ? contactPointMotion.z * 3.0 : contactPointMotion.z;
        return clipped.add(x, y, z);
    }

    private static double getCollided(double relative, double halfXsum, double mx) {
        double dx;
        double d = dx = relative > 0.0 ? relative - halfXsum : relative + halfXsum;
        if (Math.abs(mx) > Math.abs(dx)) {
            mx = dx;
        }
        return mx;
    }

    private static double getSqueezed(double localCenter, double bbCenter, double intersectSize, double currentSqueezed) {
        double diff = localCenter - bbCenter;
        double halfIntersectSize = intersectSize * 0.5;
        if (diff < -halfIntersectSize) {
            return Math.min(currentSqueezed, -halfIntersectSize - diff);
        }
        if (diff > halfIntersectSize) {
            return Math.max(currentSqueezed, halfIntersectSize - diff);
        }
        return currentSqueezed;
    }

    private static Direction.Axis getSqueezedAxis(double xsize, double ysize, double zsize) {
        if (xsize < ysize) {
            if (xsize < zsize) {
                return Direction.Axis.X;
            }
            return Direction.Axis.Z;
        }
        if (ysize < zsize) {
            return Direction.Axis.Y;
        }
        return Direction.Axis.Z;
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Direction.Axis getCollideAxis(double halfXsum, double halfYsum, double halfZsum, Vec3 relative) {
        double sx = halfXsum - Math.abs(relative.x);
        double sy = halfYsum - Math.abs(relative.y);
        double sz = halfZsum - Math.abs(relative.z);
        if (sx < sy) {
            if (sx < sz) {
                return Direction.Axis.X;
            }
            return Direction.Axis.Z;
        }
        if (sy < sz) {
            return Direction.Axis.Y;
        }
        return Direction.Axis.Z;
    }

    public static Vec3 bounceEntity(Vec3 originalMotion, Vec3 contactPointMotion, Vec3 normal, double factor) {
        if (factor == 0.0) {
            return null;
        }
        Vec3 motion = originalMotion.subtract(contactPointMotion);
        Vec3 deltav = normal.scale(factor * 2.0 * motion.dot(normal));
        if (deltav.dot(deltav) < (double)0.1f) {
            return null;
        }
        return originalMotion.subtract(deltav);
    }

    public static Vec3 rotate(Vec3 collisionLocation, float yawOffset, Direction.Axis axis) {
        return VecHelper.rotate((Vec3)collisionLocation, (double)yawOffset, (Direction.Axis)axis);
    }

    public static Vec3 getCenterOf(BlockPos blockPos) {
        if (blockPos.equals((Object)Vec3i.ZERO)) {
            return VecHelper.CENTER_OF_ORIGIN;
        }
        return Vec3.atLowerCornerWithOffset((Vec3i)blockPos, (double)0.5, (double)0.5, (double)0.5);
    }

    public static Map<Integer, WeakReference<AbstractContraptionEntity>> loadedContraptions(LevelAccessor level) {
        return (Map)ContraptionHandler.loadedContraptions.get(level);
    }

    public static boolean isCollideWithContraption(ClientLevel level, Vec3 motion, AABB bb) {
        return CreateUtilImpl.isCollideWithContraption(level, motion, bb, true);
    }

    public static boolean isCollideWithContraption(ClientLevel level, Vec3 motion, AABB bb, boolean estimate) {
        Iterator<AbstractContraptionEntity> it = CreateUtilImpl.forEachContraption((LevelAccessor)level);
        while (it.hasNext()) {
            AbstractContraptionEntity contraptionEntity = it.next();
            boolean b1 = CreateUtilImpl.isCollideWithContraption(level, motion, bb, contraptionEntity, estimate);
            if (!b1) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static Vec3 getContraptionDeltaMovement(Entity entity) {
        Entity rootEntity = entity.getRootVehicle();
        if (rootEntity instanceof AbstractContraptionEntity) {
            AbstractContraptionEntity ace = (AbstractContraptionEntity)rootEntity;
            return ace.getContactPointMotion(entity.position());
        }
        Iterator<AbstractContraptionEntity> iterator = CreateUtilImpl.forEachContraption((LevelAccessor)rootEntity.level());
        while (iterator.hasNext()) {
            AbstractContraptionEntity contraptionEntity = iterator.next();
            if (!contraptionEntity.collidingEntities.containsKey(rootEntity)) continue;
            return contraptionEntity.getContactPointMotion(entity.position());
        }
        return null;
    }
}

