/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ThreadLocalRandom;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.AsyncRenderer;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.AsyncTicker;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.addon.LightCachedParticleAddon;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleAddon;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.compat.ModListHelper;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.config.SimplePropertiesConfig;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.BindingTesselator;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.BusyWaitEvictingQueue;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionUtil;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.IterationSafeEvictingQueue;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.TrackedParticleCountsMap;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.Utils;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TrackingEmitter;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.particles.ParticleGroup;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ParticleEngine.class}, priority=500)
public abstract class MixinParticleEngine {
    @Shadow
    public Queue<Particle> particlesToAdd;
    @Shadow
    @Final
    public Map<ParticleRenderType, Queue<Particle>> particles;
    @Shadow
    protected ClientLevel level;
    @Shadow
    public Queue<TrackingEmitter> trackingEmitters;
    @Mutable
    @Shadow
    @Final
    private Object2IntOpenHashMap<ParticleGroup> trackedParticleCounts;
    @Shadow
    @Mutable
    public static List<ParticleRenderType> RENDER_ORDER;
    @Mutable
    @Shadow
    @Final
    private RandomSource random;
    @Shadow
    @Final
    public TextureManager textureManager;

    @Inject(method={"<init>"}, order=9000, at={@At(value="RETURN")})
    public void initTail(CallbackInfo ci) {
        this.trackedParticleCounts = new TrackedParticleCountsMap();
        this.particlesToAdd = new BusyWaitEvictingQueue<Particle>(1024, SimplePropertiesConfig.getLimit(), AsyncTicker::onEvicted);
        this.trackingEmitters = new BusyWaitEvictingQueue<TrackingEmitter>(256, SimplePropertiesConfig.getLimit(), AsyncTicker::onEvicted);
        this.random = new SingleThreadedRandomSource((long)ThreadLocalRandom.current().nextInt());
    }

    @Shadow
    public abstract void tickParticle(Particle var1);

    @Inject(method={"tickParticle"}, at={@At(value="INVOKE", target="Lnet/minecraft/CrashReport;forThrowable(Ljava/lang/Throwable;Ljava/lang/String;)Lnet/minecraft/CrashReport;")})
    public void onTickParticle(Particle particle, CallbackInfo ci, @Local Throwable t) {
        if (SimplePropertiesConfig.isTickAsync()) {
            throw ExceptionUtil.toThrowDirectly(t);
        }
    }

    @Overwrite
    public void tick() {
        this.particles.forEach((particleRenderType, queue) -> {
            ProfilerFiller profiler = this.level.getProfiler();
            profiler.push(particleRenderType.toString());
            AsyncTicker.PARTICLE_OPERATIONS.add(() -> this.tickParticleList((Collection<Particle>)queue));
            profiler.pop();
        });
        AsyncTicker.PARTICLE_OPERATIONS.add(() -> {
            for (TrackingEmitter emitter : this.trackingEmitters) {
                if (AsyncTicker.isCancelled() && !SimplePropertiesConfig.forceDoneParticleTick()) {
                    return;
                }
                if (!emitter.isAlive()) continue;
                if (((ParticleAddon)emitter).asyncparticles$isTickSync()) {
                    AsyncTicker.recordSync((Particle)emitter);
                    continue;
                }
                try {
                    emitter.tick();
                }
                catch (Throwable t) {
                    AsyncTicker.onTickingParticleException((Particle)emitter, t);
                }
            }
        });
        AsyncTicker.waitForCleanUp();
        if (!this.particlesToAdd.isEmpty()) {
            for (Particle particle : this.particlesToAdd) {
                if (((ParticleAddon)particle).asyncparticles$isTickSync()) {
                    AsyncTicker.recordSync(particle);
                }
                Queue queue2 = this.particles.computeIfAbsent(particle.getRenderType(), k -> {
                    IterationSafeEvictingQueue<Particle> queue1 = new IterationSafeEvictingQueue<Particle>(16, SimplePropertiesConfig.getLimit(), AsyncTicker::onEvicted);
                    AsyncTicker.PARTICLE_OPERATIONS.add(() -> this.tickParticleList(queue1));
                    if (!ModListHelper.IS_FORGE && k != ParticleRenderType.NO_RENDER && !RENDER_ORDER.contains(k)) {
                        this.asyncparticles$addToOrderList((ParticleRenderType)k);
                    }
                    return queue1;
                });
                queue2.add(particle);
            }
            this.particlesToAdd.clear();
        }
    }

    @Unique
    public void asyncparticles$addToOrderList(ParticleRenderType k) {
        ArrayList<ParticleRenderType> list = new ArrayList<ParticleRenderType>(RENDER_ORDER.size() + 1);
        for (ParticleRenderType type : RENDER_ORDER) {
            if (AsyncRenderer.getBTesselator((ParticleRenderType)type, (TextureManager)this.textureManager).shouldSync) continue;
            list.add(type);
        }
        BindingTesselator bTesselator = AsyncRenderer.getBTesselator(k, this.textureManager);
        if (!bTesselator.shouldSync) {
            list.add(k);
        }
        for (ParticleRenderType type : RENDER_ORDER) {
            if (!AsyncRenderer.getBTesselator((ParticleRenderType)type, (TextureManager)this.textureManager).shouldSync) continue;
            list.add(type);
        }
        if (bTesselator.shouldSync) {
            list.add(k);
        }
        RENDER_ORDER = list;
    }

    @Overwrite
    private void tickParticleList(Collection<Particle> collection) {
        if (collection.isEmpty()) {
            return;
        }
        for (Particle particle : collection) {
            LightCachedParticleAddon lightCachedParticle;
            if (AsyncTicker.isCancelled() && !SimplePropertiesConfig.forceDoneParticleTick()) {
                return;
            }
            if (!particle.isAlive()) {
                Utils.DUMMY_ITERATOR.remove();
                continue;
            }
            if (((ParticleAddon)particle).asyncparticles$isTicked()) {
                if (!(particle instanceof LightCachedParticleAddon)) continue;
                lightCachedParticle = (LightCachedParticleAddon)particle;
                if (!SimplePropertiesConfig.particleLightCache()) continue;
                lightCachedParticle.asyncparticles$refresh();
                continue;
            }
            if (((ParticleAddon)particle).asyncparticles$isTickSync()) {
                AsyncTicker.recordSync(particle);
                continue;
            }
            try {
                this.tickParticle(particle);
                if (particle instanceof LightCachedParticleAddon) {
                    lightCachedParticle = (LightCachedParticleAddon)particle;
                    if (SimplePropertiesConfig.particleLightCache()) {
                        lightCachedParticle.asyncparticles$refresh();
                    }
                }
                ((ParticleAddon)particle).asyncparticles$setTicked();
            }
            catch (Throwable t) {
                AsyncTicker.onTickingParticleException(particle, t);
            }
        }
    }

    @Inject(method={"add"}, at={@At(value="HEAD")})
    public void add(Particle particle, CallbackInfo ci) {
        if (!AsyncTicker.shouldTickParticles && SimplePropertiesConfig.isTickAsync()) {
            particle.remove();
        } else if (particle instanceof LightCachedParticleAddon) {
            LightCachedParticleAddon lightCachedParticle = (LightCachedParticleAddon)particle;
            if (SimplePropertiesConfig.particleLightCache()) {
                lightCachedParticle.asyncparticles$refresh();
            }
        }
    }

    @Inject(method={"clearParticles"}, at={@At(value="HEAD")})
    public void redirectClearParticles(CallbackInfo ci) {
        this.particlesToAdd.forEach(AsyncTicker::onEvicted);
        this.particlesToAdd = new BusyWaitEvictingQueue<Particle>(1024, SimplePropertiesConfig.getLimit(), AsyncTicker::onEvicted);
        this.trackingEmitters.forEach(AsyncTicker::onEvicted);
        this.trackingEmitters = new BusyWaitEvictingQueue<TrackingEmitter>(256, SimplePropertiesConfig.getLimit(), AsyncTicker::onEvicted);
        this.particles.values().forEach(queue -> queue.forEach(AsyncTicker::onEvicted));
        AsyncTicker.onParticleEngineClear();
    }
}

