/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client.mixin.fabric.particlerain;

import java.util.Collections;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.compat.particlerain.WeatherParticleAddon;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.mixin.fabric.particlerain.MixinWeatherParticle;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import pigcart.particlerain.particle.RainParticle;

@Mixin(value={RainParticle.class})
public abstract class MixinRainParticle
extends MixinWeatherParticle {
    protected MixinRainParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lpigcart/particlerain/particle/WeatherParticle;tick()V")})
    private void onTick(CallbackInfo ci) {
        if (!this.level.getFluidState((BlockPos)this.pos).isEmpty()) {
            this.asyncparticles$setInvisible(true);
        }
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(CallbackInfo ci) {
        this.setSize(3.8f, 3.8f);
    }

    @Override
    public void move(double d, double e, double f) {
        if (this.stoppedByCollision) {
            return;
        }
        double g = d;
        double h = e;
        double i = f;
        if (this.hasPhysics && (d != 0.0 || e != 0.0 || f != 0.0) && d * d + e * e + f * f < MAXIMUM_COLLISION_VELOCITY_SQUARED) {
            Vec3 originalMotion = new Vec3(d, e, f);
            Vec3 apply = WeatherParticleAddon.Type.RAIN.collide(this.level, new Vec3(this.x, this.y, this.z), originalMotion, this.asyncparticles$getWeatherAABB());
            if (apply == null) {
                this.asyncparticles$setInvisible(true);
                this.remove();
                return;
            }
            Vec3 motion = Entity.collideBoundingBox(null, (Vec3)apply, (AABB)this.asyncparticles$getWeatherAABB(), (Level)this.level, Collections.emptyList());
            if (!apply.equals((Object)originalMotion) && motion.equals((Object)apply)) {
                d = apply.x;
                e = apply.y;
                f = apply.z;
            } else {
                double d1 = Math.abs(motion.y / h);
                double d2 = g * d1;
                d = Math.abs(d2) > Math.abs(motion.x) ? motion.x : d2;
                e = motion.y;
                double d3 = i * d1;
                double d4 = f = Math.abs(d3) > Math.abs(motion.z) ? motion.z : d3;
            }
        }
        if (d != 0.0 || e != 0.0 || f != 0.0) {
            this.asyncparticles$setWeatherAABB(this.asyncparticles$getWeatherAABB().move(d, e, f));
            this.setBoundingBox(this.getBoundingBox().move(d, e, f));
            this.setLocationFromBoundingbox();
        }
        if (Math.abs(h) >= (double)1.0E-5f && Math.abs(e) < (double)1.0E-5f) {
            this.stoppedByCollision = true;
        }
        this.onGround = h != e && h < 0.0;
        if (g != d) {
            this.xd = 0.0;
        }
        if (i != f) {
            this.zd = 0.0;
        }
    }
}

