/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client.mixin.neoforge;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.AsyncRenderer;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleAddon;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.config.SimplePropertiesConfig;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.BindingTesselator;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.FakeTesselator;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ParticleEngine.class}, priority=500)
public abstract class MixinParticleEngine_Render {
    @Shadow
    @Final
    public Map<ParticleRenderType, Queue<Particle>> particles;
    @Shadow
    @Final
    public TextureManager textureManager;

    @Overwrite(remap=false)
    public void render(LightTexture lightTexture, Camera camera, float f, @Nullable Frustum ignored, Predicate<ParticleRenderType> renderTypePredicate) {
        ProfilerFiller profiler = Minecraft.getInstance().getProfiler();
        profiler.push("prepare");
        Frustum frustum = AsyncRenderer.frustum;
        lightTexture.turnOnLightLayer();
        RenderSystem.activeTexture((int)33986);
        RenderSystem.activeTexture((int)33984);
        profiler.pop();
        for (ParticleRenderType particleRenderType : this.particles.keySet()) {
            Queue<Particle> queue;
            if (particleRenderType == ParticleRenderType.NO_RENDER || !renderTypePredicate.test(particleRenderType) || (queue = this.particles.get(particleRenderType)) == null || queue.isEmpty()) continue;
            BindingTesselator tesselator = AsyncRenderer.getBTesselator(particleRenderType, this.textureManager);
            RenderSystem.setShader(GameRenderer::getParticleShader);
            RenderSystem.enableCull();
            RenderSystem.enableDepthTest();
            particleRenderType.begin((Tesselator)FakeTesselator.getFakeInstance(), this.textureManager);
            profiler.push("render_sync");
            boolean shouldSync = tesselator.shouldSync;
            Collection<Particle> syncParticles = shouldSync ? queue : AsyncRenderer.getSync(particleRenderType);
            BufferBuilder bufferBuilder = tesselator.begin();
            if (!syncParticles.isEmpty()) {
                float f2 = f + 1.0f;
                for (Particle particle : syncParticles) {
                    float f3;
                    if (!particle.isAlive()) continue;
                    float f4 = f3 = ((ParticleAddon)particle).asyncparticles$isTicked() ? f : f2;
                    if (shouldSync && SimplePropertiesConfig.isCullParticles() && !frustum.isVisible(particle.getRenderBoundingBox(f3))) continue;
                    try {
                        particle.render((VertexConsumer)bufferBuilder, camera, f3);
                    }
                    catch (Throwable t) {
                        throw AsyncRenderer.constructCrashReport(particle, particleRenderType, t);
                    }
                }
            }
            profiler.popPush("build_buffer");
            MeshData meshData = bufferBuilder.build();
            if (meshData != null) {
                profiler.popPush("upload_particles");
                BufferUploader.drawWithShader((MeshData)meshData);
            }
            profiler.pop();
        }
        profiler.push("cleanup");
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        lightTexture.turnOffLightLayer();
        profiler.pop();
    }
}

