/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client.mixin.neoforge.create;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.depot.DepotBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.ThreadUtil;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DepotBehaviour.class}, remap=false)
public abstract class MixinDepotBehaviour
extends BlockEntityBehaviour {
    @Shadow
    List<TransportedItemStack> incoming;
    @Shadow
    TransportedItemStack heldItem;

    @Shadow
    protected abstract boolean tick(TransportedItemStack var1);

    public MixinDepotBehaviour(SmartBlockEntity be) {
        super(be);
    }

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Ljava/util/List;iterator()Ljava/util/Iterator;"))
    private Iterator<TransportedItemStack> onTick(List<TransportedItemStack> instance, @Local(name={"world"}) Level world) {
        if (!world.isClientSide) {
            return instance.iterator();
        }
        HashSet<TransportedItemStack> toRemove = new HashSet<TransportedItemStack>();
        for (TransportedItemStack ts : this.incoming) {
            if (!this.tick(ts) || !this.blockEntity.isVirtual()) continue;
            if (this.heldItem == null) {
                this.heldItem = ts;
            } else if (!ItemHelper.canItemStackAmountsStack((ItemStack)this.heldItem.stack, (ItemStack)ts.stack)) {
                Vec3 vec = VecHelper.getCenterOf((Vec3i)this.blockEntity.getBlockPos());
                Containers.dropItemStack((Level)this.blockEntity.getLevel(), (double)vec.x, (double)(vec.y + 0.5), (double)vec.z, (ItemStack)ts.stack);
            } else {
                this.heldItem.stack.grow(ts.stack.getCount());
            }
            toRemove.add(ts);
            this.blockEntity.notifyUpdate();
        }
        this.incoming.removeAll(toRemove);
        return Collections.emptyIterator();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(SmartBlockEntity be, CallbackInfo ci) {
        Level level = be.getLevel();
        if (level == null) {
            if (ThreadUtil.isOnClientTickThread()) {
                this.incoming = new CopyOnWriteArrayList<TransportedItemStack>(this.incoming);
            }
        } else if (level.isClientSide) {
            this.incoming = new CopyOnWriteArrayList<TransportedItemStack>(this.incoming);
        }
    }

    @WrapOperation(method={"read"}, at={@At(value="INVOKE", target="Lnet/createmod/catnip/nbt/NBTHelper;readCompoundList(Lnet/minecraft/nbt/ListTag;Ljava/util/function/Function;)Ljava/util/List;")})
    private <T> List<T> readCompoundList(ListTag listNBT, Function<CompoundTag, T> deserializer, Operation<List<T>> original) {
        Level level = this.blockEntity.getLevel();
        if (level == null ? ThreadUtil.isOnClientTickThread() : level.isClientSide) {
            return new CopyOnWriteArrayList((Collection)original.call(new Object[]{listNBT, deserializer}));
        }
        return (List)original.call(new Object[]{listNBT, deserializer});
    }
}

