/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client.mixin.neoforge.particlerain;

import com.leclowndu93150.particlerain.particle.WeatherParticle;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collections;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.compat.particlerain.ParticleRainCompat;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.compat.particlerain.WeatherParticleAddon;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WeatherParticle.class})
public abstract class MixinWeatherParticle
extends TextureSheetParticle
implements WeatherParticleAddon {
    @Unique
    private boolean asyncparticles$invisible;
    @Unique
    private AABB asyncparticles$weathersAABB = INITIAL_AABB;

    @Shadow
    public abstract void remove();

    @Override
    public AABB asyncparticles$getWeatherAABB() {
        return this.asyncparticles$weathersAABB;
    }

    @Override
    public void asyncparticles$setWeatherAABB(AABB aabb) {
        this.asyncparticles$weathersAABB = aabb;
    }

    @Override
    public boolean asyncparticles$invisible() {
        return this.asyncparticles$invisible;
    }

    @Override
    public void asyncparticles$setInvisible(boolean visible) {
        this.asyncparticles$invisible = visible;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(CallbackInfo ci) {
        ParticleRainCompat.asyncparticles$particleCount.getAndIncrement();
        this.asyncparticles$setWeatherAABB(AABB.ofSize((Vec3)new Vec3(this.x, this.y, this.z), (double)3.8, (double)3.8, (double)3.8));
    }

    @Inject(method={"remove"}, at={@At(value="FIELD", remap=false, ordinal=0, target="Lcom/leclowndu93150/particlerain/ParticleRainClient;particleCount:I")})
    private void onRemove(CallbackInfo ci) {
        ParticleRainCompat.asyncparticles$particleCount.getAndDecrement();
    }

    protected MixinWeatherParticle(ClientLevel clientLevel, double d, double e, double f) {
        super(clientLevel, d, e, f);
    }

    @ModifyConstant(method={"tick"}, constant={@Constant(doubleValue=0.2)})
    private double onTick(double original) {
        return 2.1;
    }

    public void move(double d, double e, double f) {
        if (this.stoppedByCollision) {
            return;
        }
        double g = d;
        double h = e;
        double i = f;
        if (this.hasPhysics && (d != 0.0 || e != 0.0 || f != 0.0) && d * d + e * e + f * f < MAXIMUM_COLLISION_VELOCITY_SQUARED) {
            Vec3 position = new Vec3(this.x, this.y, this.z);
            Vec3 apply = WeatherParticleAddon.Type.OTHER.collide(this.level, position, new Vec3(d, e, f), this.asyncparticles$getWeatherAABB());
            if (apply == null) {
                this.asyncparticles$setInvisible(true);
                this.remove();
                return;
            }
            Vec3 motion = Entity.collideBoundingBox(null, (Vec3)apply, (AABB)this.getBoundingBox(), (Level)this.level, Collections.emptyList());
            d = motion.x;
            e = motion.y;
            f = motion.z;
        }
        if (d != 0.0 || e != 0.0 || f != 0.0) {
            this.asyncparticles$setWeatherAABB(this.asyncparticles$getWeatherAABB().move(d, e, f));
            this.setBoundingBox(this.getBoundingBox().move(d, e, f));
            this.setLocationFromBoundingbox();
        }
        if (Math.abs(h) >= (double)1.0E-5f && Math.abs(e) < (double)1.0E-5f) {
            this.stoppedByCollision = true;
        }
        boolean bl = this.onGround = h != e && h < 0.0;
        if (g != d) {
            this.xd = 0.0;
        }
        if (i != f) {
            this.zd = 0.0;
        }
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float f) {
        if (this.asyncparticles$invisible()) {
            return;
        }
        super.render(vertexConsumer, camera, f);
    }
}

