/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client.util;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.function.Supplier;

public class SpinLock {
    private static final VarHandle OWNER;
    private volatile Thread owner;

    public void lock() {
        Thread thread = Thread.currentThread();
        if (OWNER.compareAndSet(this, null, thread)) {
            return;
        }
        if (thread == this.owner) {
            throw new IllegalMonitorStateException("Attempt to lock an already locked lock!");
        }
        while (!OWNER.compareAndSet(this, null, thread)) {
            Thread.onSpinWait();
        }
    }

    public void unlock() {
        Thread thread = Thread.currentThread();
        if (!OWNER.compareAndSet(this, thread, null)) {
            throw new IllegalMonitorStateException("Attempt to unlock an non-locked lock!");
        }
    }

    public AutoCloseable sugar() {
        this.lock();
        return this::unlock;
    }

    public void wrap(Runnable runnable) {
        this.lock();
        try {
            runnable.run();
        }
        finally {
            this.unlock();
        }
    }

    public <T> T wrap(Supplier<T> supplier) {
        this.lock();
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.unlock();
        }
    }

    static {
        try {
            OWNER = MethodHandles.lookup().findVarHandle(SpinLock.class, "owner", Thread.class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

