/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.AsyncTicker;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleAddon;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.compat.InternalRenderingMode;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.compat.ModListHelper;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.compat.iris.IrisCompat;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.config.ConfigHelper;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.BindingTesselator;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionTracker;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionUtil;
import net.irisshaders.iris.fantastic.ParticleRenderingPhase;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ItemPickupParticle;
import net.minecraft.client.particle.MobAppearanceParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class AsyncRenderer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Set<Class<? extends Particle>> SYNC_PARTICLE_TYPES = Collections.newSetFromMap(new IdentityHashMap());
    public static final ForkJoinPool EXECUTOR;
    public static final String THREAD_PREFIX = "AsyncParticleRenderer";
    public static Frustum frustum;
    private static Consumer<String> debugConsumer;
    private static CompletableFuture<Void> asyncTask;
    private static boolean mixedParticleRenderingSetting;
    private static int asyncTasksSize;
    private static final ExceptionTracker<Class<? extends Particle>> EXCEPTION_TRACKER;
    private static final Map<ParticleRenderType, BindingTesselator> BTESSELATORS;
    private static final Map<ParticleRenderType, Set<Particle>> SYNC_PARTICLES;

    private static void addSyncByClassName(String className) {
        try {
            SYNC_PARTICLE_TYPES.add(Class.forName(className));
        }
        catch (Exception e) {
            LOGGER.warn("", (Throwable)e);
        }
    }

    public static void start(float f, Camera camera, int irm) {
        AsyncRenderer.tryDebug();
        switch (irm) {
            case 4: {
                mixedParticleRenderingSetting = true;
                return;
            }
            case 0: 
            case 2: {
                mixedParticleRenderingSetting = false;
                return;
            }
            case 7: {
                mixedParticleRenderingSetting = true;
                break;
            }
            default: {
                mixedParticleRenderingSetting = false;
            }
        }
        Minecraft mc = Minecraft.getInstance();
        ProfilerFiller profiler = Profiler.get();
        profiler.push("begin_particles");
        AsyncRenderer.clearSync();
        ParticleEngine particleEngine = mc.particleEngine;
        ObjectArrayList asyncTasks = new ObjectArrayList(asyncTasksSize);
        for (ParticleRenderType particleRenderType : ModListHelper.IS_FORGE ? particleEngine.particles.keySet() : ParticleEngine.RENDER_ORDER) {
            BindingTesselator bTesselator;
            Queue queue;
            if (particleRenderType == ParticleRenderType.NO_RENDER || (queue = (Queue)particleEngine.particles.get(particleRenderType)) == null || queue.isEmpty() || (bTesselator = AsyncRenderer.getBTesselator(particleRenderType)) == BindingTesselator.EMPTY) continue;
            asyncTasks.add((Object)CompletableFuture.runAsync(() -> AsyncRenderer.renderParticles(f, camera, queue, particleRenderType, bTesselator.begin()), EXECUTOR).exceptionally(AsyncRenderer::renderAsyncExceptionally));
        }
        int size = asyncTasksSize = asyncTasks.size();
        asyncTask = CompletableFuture.allOf((CompletableFuture[])asyncTasks.toArray((Object[])new CompletableFuture[size]));
        profiler.pop();
    }

    private static void renderParticles(float f, Camera camera, Queue<Particle> particles, ParticleRenderType particleRenderType, BufferBuilder bufferBuilder) {
        Frustum frustum = AsyncRenderer.frustum;
        boolean enableCull = ConfigHelper.isCullParticles();
        float f2 = f + 1.0f;
        for (Particle particle : particles) {
            float f3;
            if (!particle.isAlive()) continue;
            float f4 = f3 = ((ParticleAddon)particle).asyncparticles$isTicked() ? f : f2;
            if (enableCull && !frustum.isVisible(((ParticleAddon)particle).getRenderBoundingBox(f3))) continue;
            if (((ParticleAddon)particle).asyncparticles$isRenderSync()) {
                AsyncRenderer.recordSync(particleRenderType, particle);
                continue;
            }
            try {
                particle.render((VertexConsumer)bufferBuilder, camera, f3);
            }
            catch (Throwable t) {
                AsyncRenderer.onRenderingParticleException(particleRenderType, particle, t);
            }
        }
    }

    private static void onRenderingParticleException(ParticleRenderType particleRenderType, Particle particle, Throwable t) {
        boolean tolerable = AsyncTicker.isTolerable(t);
        Class<? extends Particle> particleClass = ((ParticleAddon)particle).asyncparticles$getRealClass();
        if (tolerable && !EXCEPTION_TRACKER.addException(particleClass, t)) {
            return;
        }
        ((ParticleAddon)particle).asyncparticles$setRenderSync();
        if (!AsyncRenderer.shouldSync(particleClass)) {
            if (!tolerable) {
                LOGGER.warn("Exception while rendering particle {}, marking as sync", (Object)particle, (Object)t);
            } else {
                LOGGER.warn("Exception {} thrown while rendering particle {} exceeds the threshold, please contact the author: {}", new Object[]{t.getClass().getSimpleName(), particle, "https://github.com/Harveykang/AsyncParticles/issues", t});
            }
            AsyncRenderer.markAsSync(particleClass);
        }
        AsyncRenderer.recordSync(particleRenderType, particle);
    }

    private static Void renderAsyncExceptionally(Throwable e) {
        LOGGER.error("Error rendering particle", e);
        Minecraft mc1 = Minecraft.getInstance();
        if (mc1.level != null && mc1.player != null) {
            throw ExceptionUtil.toThrowDirectly(e);
        }
        return null;
    }

    public static void endAll(Camera camera, float f, Collection<ParticleRenderType> renderOrder) {
        AsyncRenderer.tryWaitingForAsyncTasks();
        for (ParticleRenderType particleRenderType : renderOrder) {
            MeshData meshData;
            BufferBuilder builder;
            BindingTesselator tesselator = BTESSELATORS.get(particleRenderType);
            if (tesselator == null || tesselator == BindingTesselator.EMPTY) continue;
            Set<Particle> sync = AsyncRenderer.getSync(particleRenderType);
            if (sync.isEmpty()) {
                builder = tesselator.getBuilder();
                if (builder == null || !builder.building) {
                    continue;
                }
            } else {
                builder = tesselator.begin();
                float f2 = f + 1.0f;
                for (Particle particle : sync) {
                    if (!particle.isAlive()) continue;
                    float f3 = ((ParticleAddon)particle).asyncparticles$isTicked() ? f : f2;
                    try {
                        particle.render((VertexConsumer)builder, camera, f3);
                    }
                    catch (Throwable t) {
                        throw AsyncRenderer.constructCrashReport(particle, particleRenderType, t);
                    }
                }
            }
            if ((meshData = builder.build()) == null) continue;
            RenderType renderType = particleRenderType.renderType();
            if (renderType.sortOnUpload()) {
                meshData.sortQuads(tesselator.buffer, RenderSystem.getProjectionType().vertexSorting());
            }
            renderType.draw(meshData);
        }
    }

    public static void endAll(Camera camera, float f, Collection<ParticleRenderType> renderOrder, Predicate<ParticleRenderType> renderTypePredicate) {
        AsyncRenderer.tryWaitingForAsyncTasks();
        for (ParticleRenderType particleRenderType : renderOrder) {
            MeshData meshData;
            BufferBuilder builder;
            BindingTesselator tesselator;
            if (particleRenderType.renderType() == null || !renderTypePredicate.test(particleRenderType) || (tesselator = BTESSELATORS.get(particleRenderType)) == null || tesselator == BindingTesselator.EMPTY) continue;
            Set<Particle> sync = AsyncRenderer.getSync(particleRenderType);
            if (sync.isEmpty()) {
                builder = tesselator.getBuilder();
                if (builder == null || !builder.building) {
                    continue;
                }
            } else {
                builder = tesselator.begin();
                float f2 = f + 1.0f;
                for (Particle particle : sync) {
                    if (!particle.isAlive()) continue;
                    float f3 = ((ParticleAddon)particle).asyncparticles$isTicked() ? f : f2;
                    try {
                        particle.render((VertexConsumer)builder, camera, f3);
                    }
                    catch (Throwable t) {
                        throw AsyncRenderer.constructCrashReport(particle, particleRenderType, t);
                    }
                }
            }
            if ((meshData = builder.build()) == null) continue;
            RenderType renderType = particleRenderType.renderType();
            if (renderType.sortOnUpload()) {
                meshData.sortQuads(tesselator.buffer, RenderSystem.getProjectionType().vertexSorting());
            }
            renderType.draw(meshData);
        }
    }

    public static void waitForAsyncTasks() {
        if (asyncTask != null) {
            asyncTask.join();
            asyncTask = null;
        }
    }

    public static void tryWaitingForAsyncTasks() {
        AsyncRenderer.waitForAsyncTasks();
    }

    public static ReportedException constructCrashReport(Particle particle, ParticleRenderType particleRenderType, Throwable t) {
        AsyncTicker.debugLater(arg_0 -> ((Logger)LOGGER).info(arg_0));
        AsyncTicker.tryDebug();
        AsyncRenderer.debugLater(arg_0 -> ((Logger)LOGGER).info(arg_0));
        AsyncRenderer.tryDebug();
        CrashReport crashReport = CrashReport.forThrowable((Throwable)t, (String)"Rendering Particle");
        CrashReportCategory crashReportCategory = crashReport.addCategory("Particle being rendered");
        crashReportCategory.setDetail("Particle", () -> ((Particle)particle).toString());
        crashReportCategory.setDetail("Particle Type", () -> ((ParticleRenderType)particleRenderType).toString());
        return new ReportedException(crashReport);
    }

    public static boolean isMixedParticleRendering() {
        return mixedParticleRenderingSetting;
    }

    private static void resetBTesselators() {
        BTESSELATORS.values().forEach(BindingTesselator::clear);
    }

    private static void closeBTesselators() {
        Iterator<BindingTesselator> iterator = BTESSELATORS.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().close();
            iterator.remove();
        }
    }

    public static BindingTesselator getBTesselator(ParticleRenderType particleRenderType) {
        return BTESSELATORS.computeIfAbsent(particleRenderType, AsyncRenderer::computeBTesselator);
    }

    @NotNull
    private static BindingTesselator computeBTesselator(ParticleRenderType particleRenderType) {
        RenderType renderType = particleRenderType.renderType();
        if (renderType == null) {
            return BindingTesselator.EMPTY;
        }
        return new BindingTesselator(256, renderType.mode(), renderType.format());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markAsSync(Class<? extends Particle> aClass) {
        Set<Class<? extends Particle>> set = SYNC_PARTICLE_TYPES;
        synchronized (set) {
            SYNC_PARTICLE_TYPES.add(aClass);
        }
    }

    public static boolean shouldSync(Class<?> aClass) {
        return SYNC_PARTICLE_TYPES.contains(aClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recordSync(ParticleRenderType particleRenderType, Particle particle) {
        Set particles;
        Set set = particles = SYNC_PARTICLES.computeIfAbsent(particleRenderType, k -> Collections.newSetFromMap(new IdentityHashMap()));
        synchronized (set) {
            particles.add(particle);
        }
    }

    public static Set<Particle> getSync(ParticleRenderType particleRenderType) {
        Set<Particle> set = SYNC_PARTICLES.get(particleRenderType);
        return set == null ? Collections.emptySet() : set;
    }

    private static void clearSync() {
        SYNC_PARTICLES.clear();
    }

    public static void debugLater(Consumer<String> consumer) {
        debugConsumer = consumer;
    }

    static void tryDebug() {
        if (debugConsumer != null) {
            Object[] objectArray = new Object[8];
            objectArray[0] = asyncTasksSize;
            objectArray[1] = BTESSELATORS.entrySet().stream().filter(e -> e.getValue() != BindingTesselator.EMPTY).collect(Collectors.toMap(entry -> ((ParticleRenderType)entry.getKey()).name(), e -> ((BindingTesselator)e.getValue()).buffer.capacity));
            objectArray[2] = (ModListHelper.IS_FORGE ? Minecraft.getInstance().particleEngine.particles.keySet() : ParticleEngine.RENDER_ORDER).stream().map(ParticleRenderType::name).toList();
            objectArray[3] = SYNC_PARTICLES.values().stream().mapToInt(Set::size).sum();
            objectArray[4] = SYNC_PARTICLE_TYPES.stream().map(Class::getName).toList();
            objectArray[5] = BTESSELATORS.entrySet().stream().filter(e -> e.getValue() == BindingTesselator.EMPTY).map(p -> ((ParticleRenderType)p.getKey()).name()).toList();
            objectArray[6] = switch (InternalRenderingMode.getMode()) {
                case 0 -> "SYNC";
                case 1 -> "DELAYED_ASYNC";
                case 2 -> "BEFORE_SYNC";
                case 3 -> "COMPATIBILITY_ASYNC";
                case 4 -> "MIXED_SYNC";
                case 5 -> "BEFORE_ASYNC";
                case 7 -> "MIXED_ASYNC";
                default -> "UNKNOWN";
            };
            objectArray[7] = ModListHelper.IRIS_LIKE_LOADED ? IrisCompat.getParticleRenderingSettings().name() : "DISABLED";
            debugConsumer.accept("[Debug AsyncRenderer]\nasync queue size: %d,\nbuffer capacity: %s,\nrender order: %s,\nsync particle count: %d,\nsync particle types: %s,\nsync particle render types: %s,\nparticle mode: %s,\niris particle mode: %s".formatted(objectArray));
            debugConsumer = null;
        }
    }

    public static void reset() {
        AsyncRenderer.waitForAsyncTasks();
        AsyncRenderer.closeBTesselators();
        AsyncRenderer.clearSync();
    }

    public static boolean isTranslucentPhase(Enum<?> phase) {
        return phase == ParticleRenderingPhase.TRANSLUCENT;
    }

    static {
        SYNC_PARTICLE_TYPES.add(ItemPickupParticle.class);
        SYNC_PARTICLE_TYPES.add(MobAppearanceParticle.class);
        if (ModListHelper.DUMMMMMMY_LOADED) {
            AsyncRenderer.addSyncByClassName("net.mehvahdjukaar.dummmmmmy.client.DamageNumberParticle");
        }
        if (ModListHelper.FABRIC_EFFECTIVE_LOADED) {
            AsyncRenderer.addSyncByClassName("org.ladysnake.effective.particle.SplashParticle");
        }
        if (ModListHelper.FORGE_EFFECTIVE_LOADED) {
            AsyncRenderer.addSyncByClassName("concerrox.effective.particle.SplashParticle");
        }
        AtomicInteger workerCount = new AtomicInteger(1);
        int clamp = Mth.clamp((int)(Runtime.getRuntime().availableProcessors() - 1), (int)1, (int)6);
        EXECUTOR = new ForkJoinPool(clamp, forkJoinPool -> {
            ForkJoinWorkerThread forkJoinWorkerThread = new ForkJoinWorkerThread(forkJoinPool){

                @Override
                protected void onTermination(Throwable throwable) {
                    if (throwable != null) {
                        LOGGER.warn("{} died", (Object)this.getName(), (Object)throwable);
                    } else {
                        LOGGER.debug("{} shutdown", (Object)this.getName());
                    }
                    super.onTermination(throwable);
                }
            };
            forkJoinWorkerThread.setName("AsyncParticleRenderer-" + workerCount.getAndIncrement());
            forkJoinWorkerThread.setDaemon(true);
            return forkJoinWorkerThread;
        }, Util::onThreadException, true);
        mixedParticleRenderingSetting = false;
        EXCEPTION_TRACKER = new ExceptionTracker(() -> 5000, ConfigHelper::getRenderFailurePerSecondThreshold);
        BTESSELATORS = new ConcurrentHashMap<ParticleRenderType, BindingTesselator>();
        SYNC_PARTICLES = Collections.synchronizedMap(new IdentityHashMap());
    }
}

