/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client.config;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class FallbackScreen
extends Screen {
    @Nullable
    public final Screen parent;
    public Component message;
    public final Component buttonTextLeft;
    public Consumer<FallbackScreen> buttonLeftCallback;
    public final Component buttonTextRight;
    public Consumer<FallbackScreen> buttonRightCallback;
    private final GridLayout layout = new GridLayout();
    private MultiLineTextWidget reasonWidget;
    public Button buttonLeft;
    public Button buttonRight;
    public BiConsumer<FallbackScreen, Button> buttonLeftTick;
    public BiConsumer<FallbackScreen, Button> buttonRightTick;

    public FallbackScreen(@Nullable Screen parent, Component title, Component message, Component buttonL, Consumer<FallbackScreen> buttonLeftCallback, Component buttonR, Consumer<FallbackScreen> buttonRightCallback) {
        super(title);
        this.parent = parent;
        this.message = message;
        this.buttonTextLeft = buttonL;
        this.buttonLeftCallback = buttonLeftCallback;
        this.buttonTextRight = buttonR;
        this.buttonRightCallback = buttonRightCallback;
    }

    protected void init() {
        super.init();
        this.layout.defaultCellSetting().alignHorizontallyCenter().padding(10);
        GridLayout.RowHelper rowHelper = this.layout.createRowHelper(2);
        rowHelper.addChild((LayoutElement)new StringWidget(this.title, this.font), 2);
        this.reasonWidget = new MultiLineTextWidget(this.message, this.font).setMaxWidth(this.width - 50).setCentered(true);
        rowHelper.addChild((LayoutElement)this.reasonWidget, 2);
        this.buttonLeft = Button.builder((Component)this.buttonTextLeft, button1 -> this.getButtonLeftCallback().accept(this)).bounds(this.width / 2 - 155, this.height / 6 + 96, 150, 20).build();
        this.buttonRight = Button.builder((Component)this.buttonTextRight, button1 -> this.getButtonRightCallback().accept(this)).bounds(this.width / 2 - 155 + 160, this.height / 6 + 96, 150, 20).build();
        rowHelper.addChild((LayoutElement)this.buttonLeft);
        rowHelper.addChild((LayoutElement)this.buttonRight);
        this.layout.arrangeElements();
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    private Consumer<FallbackScreen> getButtonLeftCallback() {
        return this.buttonLeftCallback;
    }

    private Consumer<FallbackScreen> getButtonRightCallback() {
        return this.buttonRightCallback;
    }

    protected void repositionElements() {
        FrameLayout.centerInRectangle((LayoutElement)this.layout, (ScreenRectangle)this.getRectangle());
    }

    public Component getNarrationMessage() {
        return CommonComponents.joinForNarration((Component[])new Component[]{this.title, this.message});
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public void tick() {
        if (this.buttonLeftTick != null) {
            this.buttonLeftTick.accept(this, this.buttonLeft);
        }
        if (this.buttonRightTick != null) {
            this.buttonRightTick.accept(this, this.buttonRight);
        }
        if (this.reasonWidget.getMessage() != this.message) {
            FallbackScreen guiScreen = new FallbackScreen(this.parent, this.title, this.message, this.buttonTextLeft, this.buttonLeftCallback, this.buttonTextRight, this.buttonRightCallback);
            guiScreen.buttonLeft = this.buttonLeft;
            guiScreen.buttonLeftTick = this.buttonLeftTick;
            guiScreen.buttonRight = this.buttonRight;
            guiScreen.buttonRightTick = this.buttonRightTick;
            this.minecraft.setScreen((Screen)guiScreen);
            return;
        }
        super.tick();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }
}

