/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client.coremod.mixin_extension.class_adjuster;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.coremod.mixin_extension.class_adjuster.MixinClassAdjuster;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.coremod.mixin_extension.class_adjuster.MixinClassProvider;
import org.spongepowered.asm.logging.ILogger;
import org.spongepowered.asm.service.MixinService;

public class MixinClassAdjusterRegistrar {
    private static final ILogger LOGGER = MixinService.getService().getLogger("asyncparticles-class-adjuster");
    private static Map<String, MixinClassAdjuster> pendingAdjusters = new HashMap<String, MixinClassAdjuster>();
    private static Set<MixinClassProvider> pendingProviders = new HashSet<MixinClassProvider>();

    public static void register(MixinClassAdjuster mixinClassAdjuster) {
        if (pendingAdjusters == null) {
            throw new IllegalStateException("Cannot register class adjuster after pre-launch!");
        }
        pendingAdjusters.put(mixinClassAdjuster.getMixinClassName(), mixinClassAdjuster);
        LOGGER.debug("Registered target modifier {}", new Object[]{mixinClassAdjuster.getClass().getName()});
    }

    public static void register(MixinClassProvider mixinClassProvider) {
        if (pendingProviders == null) {
            throw new IllegalStateException("Cannot register class provider after pre-launch!");
        }
        pendingProviders.add(mixinClassProvider);
        LOGGER.debug("Registered target modifier {}", new Object[]{mixinClassProvider.getClass().getName()});
    }

    static Map<String, MixinClassAdjuster> endAdjusters() {
        Map<String, MixinClassAdjuster> m = pendingAdjusters;
        pendingAdjusters = null;
        return m;
    }

    static Set<MixinClassProvider> endProviders() {
        Set<MixinClassProvider> l = pendingProviders;
        pendingProviders = null;
        return l;
    }
}

