/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client.mixin.fabric;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.AsyncRenderer;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleAddon;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.compat.InternalRenderingMode;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.compat.ModListHelper;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.config.ConfigHelper;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.FrustumUtil;
import net.minecraft.client.Camera;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ParticleEngine.class}, priority=500)
public abstract class MixinParticleEngine_Render {
    @Shadow
    public Map<ParticleRenderType, Queue<Particle>> particles;
    @Shadow
    public static List<ParticleRenderType> RENDER_ORDER;
    private static Enum<?> phase;

    @Overwrite
    private static void renderParticleType(Camera camera, float f, MultiBufferSource.BufferSource bufferSource, ParticleRenderType particleRenderType, Queue<Particle> particles) {
        VertexConsumer vertexconsumer = bufferSource.getBuffer(Objects.requireNonNull(particleRenderType.renderType()));
        Frustum frustum = AsyncRenderer.frustum;
        float f2 = f + 1.0f;
        boolean enableCull = ConfigHelper.isCullParticles();
        for (Particle particle : particles) {
            float f3;
            if (!particle.isAlive()) continue;
            float f4 = f3 = ((ParticleAddon)particle).asyncparticles$isTicked() ? f : f2;
            if (enableCull && !FrustumUtil.isVisible(frustum, ((ParticleAddon)particle).getRenderBoundingBox(f3))) continue;
            try {
                particle.render(vertexconsumer, camera, f3);
            }
            catch (Throwable t) {
                throw AsyncRenderer.constructCrashReport(particle, particleRenderType, t);
            }
        }
    }

    @Overwrite
    public static void renderCustomParticles(Camera camera, float f, MultiBufferSource.BufferSource bufferSource, Queue<Particle> particles) {
        PoseStack poseStack = new PoseStack();
        Frustum frustum = AsyncRenderer.frustum;
        float f2 = f + 1.0f;
        boolean enableCull = ConfigHelper.isCullParticles();
        for (Particle particle : particles) {
            float f3;
            if (!particle.isAlive()) continue;
            float f4 = f3 = ((ParticleAddon)particle).asyncparticles$isTicked() ? f : f2;
            if (enableCull && !FrustumUtil.isVisible(frustum, ((ParticleAddon)particle).getRenderBoundingBox(f3))) continue;
            try {
                particle.renderCustom(poseStack, (MultiBufferSource)bufferSource, camera, f3);
            }
            catch (Throwable t) {
                throw AsyncRenderer.constructCrashReport(particle, particle.getRenderType(), t);
            }
        }
    }

    @Overwrite
    public void render(Camera camera, float partialTick, MultiBufferSource.BufferSource bufferSource) {
        Queue<Particle> queue2;
        List<ParticleRenderType> renderOrder = RENDER_ORDER;
        if (InternalRenderingMode.isAsync()) {
            AsyncRenderer.endAll(camera, partialTick, renderOrder);
        } else {
            for (ParticleRenderType particleRenderType : renderOrder) {
                Queue<Particle> queue = this.particles.get(particleRenderType);
                if (queue == null || queue.isEmpty()) continue;
                MixinParticleEngine_Render.renderParticleType(camera, partialTick, bufferSource, particleRenderType, queue);
            }
        }
        if (!(ModListHelper.IRIS_LIKE_LOADED && AsyncRenderer.isTranslucentPhase(phase) || (queue2 = this.particles.get(ParticleRenderType.CUSTOM)) == null || queue2.isEmpty())) {
            MixinParticleEngine_Render.renderCustomParticles(camera, partialTick, bufferSource, queue2);
        }
        bufferSource.endBatch();
    }
}

