/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client.mixin.neoforge;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.ThreadUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class}, priority=1500)
public class MixinMinecraft {
    @Shadow
    @Final
    public ParticleEngine particleEngine;

    @Inject(method={"run"}, at={@At(value="HEAD")})
    private void onRun(CallbackInfo ci) {
        ThreadUtil.enqueueClientTask(() -> {
            List renderOrder = ParticleEngine.RENDER_ORDER;
            AtomicInteger orderGenerator = new AtomicInteger();
            Map insertionOrder = Collections.synchronizedMap(new IdentityHashMap(0));
            TreeMap newTreeMap = Maps.newTreeMap((o1, o2) -> {
                boolean r2;
                if (o1 == o2) {
                    return 0;
                }
                boolean r1 = o1.renderType() == null;
                boolean bl = r2 = o2.renderType() == null;
                if (r1 && r2) {
                    return MixinMinecraft.asyncparticles$compareWithIdentityHashCode(o1, o2, insertionOrder, orderGenerator);
                }
                if (r1) {
                    return -1;
                }
                if (r2) {
                    return 1;
                }
                int vanillaOne = -1;
                int vanillaTwo = -1;
                for (int i = 0; i < renderOrder.size(); ++i) {
                    ParticleRenderType geti = (ParticleRenderType)renderOrder.get(i);
                    if (vanillaOne == -1 && geti == o1) {
                        vanillaOne = i;
                    } else if (vanillaTwo == -1 && geti == o2) {
                        vanillaTwo = i;
                    }
                    if (vanillaOne < 0 || vanillaTwo < 0) continue;
                    return Integer.compare(vanillaOne, vanillaTwo);
                }
                if (vanillaOne == -1 && vanillaTwo == -1) {
                    return MixinMinecraft.asyncparticles$compareWithIdentityHashCode(o1, o2, insertionOrder, orderGenerator);
                }
                return vanillaOne >= 0 ? -1 : 1;
            });
            newTreeMap.putAll(this.particleEngine.particles);
            this.particleEngine.particles = newTreeMap;
        });
    }

    @Unique
    private static int asyncparticles$compareWithIdentityHashCode(ParticleRenderType o1, ParticleRenderType o2, Map<ParticleRenderType, Integer> insertionOrder, AtomicInteger orderGenerator) {
        int hashCompare = Integer.compare(System.identityHashCode(o1), System.identityHashCode(o2));
        if (hashCompare != 0) {
            return hashCompare;
        }
        return Integer.compare(insertionOrder.computeIfAbsent(o1, k -> orderGenerator.getAndIncrement()), insertionOrder.computeIfAbsent(o2, k -> orderGenerator.getAndIncrement()));
    }
}

