/*
 * Decompiled with CFR 0.152.
 */
package fabric.fun.qu_an.minecraft.asyncparticles.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import fabric.fun.qu_an.minecraft.asyncparticles.client.AsyncTicker;
import fabric.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleAddon;
import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.ModListHelper;
import fabric.fun.qu_an.minecraft.asyncparticles.client.config.SimplePropertiesConfig;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.BindingTesselator;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionTracker;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionUtil;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.FakeBufferBuilder;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.FrustumUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.api.v0.IrisApi;
import net.irisshaders.iris.fantastic.ParticleRenderingPhase;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.irisshaders.iris.shaderpack.properties.ParticleRenderingSettings;
import net.minecraft.class_10209;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_3999;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_4604;
import net.minecraft.class_693;
import net.minecraft.class_700;
import net.minecraft.class_702;
import net.minecraft.class_703;
import net.minecraft.class_761;
import net.minecraft.class_9801;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public class AsyncRenderer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Set<Class<? extends class_703>> SYNC_PARTICLE_TYPES = Collections.newSetFromMap(new IdentityHashMap());
    private static final Map<class_3999, Set<class_703>> SYNC_PARTICLES;
    public static final ForkJoinPool EXECUTOR;
    public static final String THREAD_PREFIX = "AsyncParticleRenderer";
    public static class_4604 frustum;
    private static Consumer<String> debugConsumer;
    public static CompletableFuture<Void> asyncTask;
    private static boolean mixedParticleRenderingSetting;
    private static int asyncTasksSize;
    private static final ExceptionTracker<Class<? extends class_703>> EXCEPTION_TRACKER;
    private static final Map<class_3999, BindingTesselator> BTESSELATORS;

    private static void addSyncByClassName(String className) {
        try {
            SYNC_PARTICLE_TYPES.add(Class.forName(className));
        }
        catch (Exception e) {
            LOGGER.warn("", (Throwable)e);
        }
    }

    public static void start(float f, class_4184 camera, Matrix4f frustumMatrix, Matrix4f projectionMatrix) {
        class_310 mc = class_310.method_1551();
        class_761 levelRenderer = mc.field_1769;
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15405("culling");
        boolean flag = levelRenderer.field_4056 != null;
        frustum = flag ? levelRenderer.field_4056 : levelRenderer.field_27740;
        profiler.method_15405("captureFrustum");
        if (levelRenderer.field_4090) {
            class_243 vec3 = camera.method_19326();
            levelRenderer.field_4056 = flag ? new class_4604(frustumMatrix, projectionMatrix) : levelRenderer.field_27740;
            levelRenderer.field_4056.method_23088(vec3.field_1352, vec3.field_1351, vec3.field_1350);
            levelRenderer.field_4090 = false;
        }
        if (!SimplePropertiesConfig.isRenderAsync()) {
            AsyncRenderer.captureParticleRenderingSetting();
            AsyncRenderer.tryDebug();
            return;
        }
        profiler.method_15405("async_particles");
        AsyncRenderer.tryDebug();
        AsyncRenderer.clearSync();
        AsyncRenderer.captureParticleRenderingSetting();
        profiler.method_15396("render_async");
        class_702 particleEngine = mc.field_1713;
        List renderOrder = ModListHelper.IS_FORGE ? particleEngine.field_3830.keySet() : class_702.field_17820;
        ObjectArrayList asyncTasks = new ObjectArrayList(renderOrder.size());
        for (class_3999 particleRenderType : renderOrder) {
            class_287 bufferBuilder;
            Queue queue;
            if (particleRenderType.comp_3341() == null || (queue = (Queue)particleEngine.field_3830.get(particleRenderType)) == null || queue.isEmpty() || (bufferBuilder = AsyncRenderer.beginBufferBuilder(particleRenderType)) == FakeBufferBuilder.INSTANCE) continue;
            CompletionStage future = CompletableFuture.runAsync(() -> AsyncRenderer.renderParticles(f, camera, queue, particleRenderType, bufferBuilder), EXECUTOR).exceptionally(AsyncRenderer::renderAsyncExceptionally);
            asyncTasks.add((Object)future);
        }
        int size = asyncTasksSize = asyncTasks.size();
        asyncTask = CompletableFuture.allOf((CompletableFuture[])asyncTasks.toArray((Object[])new CompletableFuture[size]));
        profiler.method_15407();
    }

    private static void renderParticles(float f, class_4184 camera, Queue<class_703> particles, class_3999 particleRenderType, class_287 bufferBuilder) {
        float f2 = f + 1.0f;
        class_4604 frustum = AsyncRenderer.frustum;
        for (class_703 particle : particles) {
            float f3;
            if (!particle.method_3086()) continue;
            float f4 = f3 = ((ParticleAddon)particle).asyncparticles$isTicked() ? f : f2;
            if (SimplePropertiesConfig.isCullParticles() && !FrustumUtil.isVisible(frustum, ((ParticleAddon)particle).getRenderBoundingBox(f3))) continue;
            if (((ParticleAddon)particle).asyncparticles$isRenderSync()) {
                AsyncRenderer.recordSync(particleRenderType, particle);
                continue;
            }
            try {
                particle.method_3074((class_4588)bufferBuilder, camera, f3);
            }
            catch (Throwable t) {
                boolean tolerable = AsyncTicker.isTolerable(t);
                if (tolerable && !EXCEPTION_TRACKER.addException(particle.getClass(), t)) continue;
                ((ParticleAddon)particle).asyncparticles$setRenderSync();
                if (!AsyncRenderer.shouldSync(particle.getClass())) {
                    if (!tolerable) {
                        LOGGER.warn("Exception while rendering particle {}, marking as sync", (Object)particle, (Object)t);
                    } else {
                        LOGGER.warn("Exception {} thrown while rendering particle {} exceeds the threshold, please contact the author: {}", new Object[]{t.getClass().getSimpleName(), particle, "https://github.com/Harveykang/AsyncParticles/issues", t});
                    }
                    AsyncRenderer.markAsSync(particle.getClass());
                }
                AsyncRenderer.recordSync(particleRenderType, particle);
            }
        }
    }

    private static Void renderAsyncExceptionally(Throwable e) {
        LOGGER.error("Error rendering particle", e);
        class_310 mc1 = class_310.method_1551();
        if (mc1.field_1687 != null && mc1.field_1724 != null) {
            throw ExceptionUtil.toThrowDirectly(e);
        }
        return null;
    }

    public static void endAll(class_4184 camera, float f, Collection<class_3999> renderOrder) {
        AsyncRenderer.waitForAsyncTasks();
        for (class_3999 particleRenderType : renderOrder) {
            class_9801 meshData;
            class_287 builder;
            BindingTesselator tesselator = BTESSELATORS.get(particleRenderType);
            if (tesselator == null || tesselator == BindingTesselator.EMPTY) continue;
            Set<class_703> sync = AsyncRenderer.getSync(particleRenderType);
            if (sync.isEmpty()) {
                builder = tesselator.getBuilder();
                if (builder == null || !builder.field_1556) {
                    continue;
                }
            } else {
                builder = tesselator.begin();
                float f2 = f + 1.0f;
                for (class_703 particle : sync) {
                    if (!particle.method_3086()) continue;
                    float f3 = ((ParticleAddon)particle).asyncparticles$isTicked() ? f : f2;
                    try {
                        particle.method_3074((class_4588)builder, camera, f3);
                    }
                    catch (Throwable t) {
                        throw AsyncRenderer.constructCrashReport(particle, particleRenderType, t);
                    }
                }
            }
            if ((meshData = builder.method_60794()) == null) continue;
            class_1921 renderType = particleRenderType.comp_3341();
            if (renderType.method_60894()) {
                meshData.method_60819(tesselator.buffer, RenderSystem.getProjectionType().method_65045());
            }
            renderType.method_60895(meshData);
        }
    }

    public static void endAll(class_4184 camera, float f, Predicate<class_3999> renderTypePredicate, Collection<class_3999> renderOrder) {
        AsyncRenderer.waitForAsyncTasks();
        for (class_3999 particleRenderType : renderOrder) {
            class_9801 meshData;
            class_287 builder;
            BindingTesselator tesselator;
            if (particleRenderType.comp_3341() == null || !renderTypePredicate.test(particleRenderType) || (tesselator = BTESSELATORS.get(particleRenderType)) == null || tesselator == BindingTesselator.EMPTY) continue;
            Set<class_703> sync = AsyncRenderer.getSync(particleRenderType);
            if (sync.isEmpty()) {
                builder = tesselator.getBuilder();
                if (builder == null || !builder.field_1556) {
                    continue;
                }
            } else {
                builder = tesselator.begin();
                float f2 = f + 1.0f;
                for (class_703 particle : sync) {
                    if (!particle.method_3086()) continue;
                    float f3 = ((ParticleAddon)particle).asyncparticles$isTicked() ? f : f2;
                    try {
                        particle.method_3074((class_4588)builder, camera, f3);
                    }
                    catch (Throwable t) {
                        throw AsyncRenderer.constructCrashReport(particle, particleRenderType, t);
                    }
                }
            }
            if ((meshData = builder.method_60794()) == null) continue;
            class_1921 renderType = particleRenderType.comp_3341();
            if (renderType.method_60894()) {
                meshData.method_60819(tesselator.buffer, RenderSystem.getProjectionType().method_65045());
            }
            renderType.method_60895(meshData);
        }
    }

    public static void waitForAsyncTasks() {
        if (asyncTask != null) {
            asyncTask.join();
            asyncTask = null;
        }
    }

    public static class_148 constructCrashReport(class_703 particle, class_3999 particleRenderType, Throwable t) {
        AsyncTicker.debugLater(arg_0 -> ((Logger)LOGGER).info(arg_0));
        AsyncTicker.tryDebug();
        AsyncRenderer.debugLater(arg_0 -> ((Logger)LOGGER).info(arg_0));
        AsyncRenderer.tryDebug();
        class_128 crashReport = class_128.method_560((Throwable)t, (String)"Rendering Particle");
        class_129 crashReportCategory = crashReport.method_562("Particle being rendered");
        crashReportCategory.method_577("Particle", () -> ((class_703)particle).toString());
        crashReportCategory.method_577("Particle Type", () -> ((class_3999)particleRenderType).toString());
        if (particleRenderType.comp_3341() != null) {
            crashReportCategory.method_577("Render Type", () -> ((class_1921)particleRenderType.comp_3341()).toString());
        } else {
            crashReportCategory.method_578("Render Type", (Object)"Custom");
        }
        return new class_148(crashReport);
    }

    private static void captureParticleRenderingSetting() {
        if (ModListHelper.IRIS_LIKE_LOADED) {
            mixedParticleRenderingSetting = Iris.isPackInUseQuick() && AsyncRenderer.getParticleRenderingSettings0() == ParticleRenderingSettings.MIXED;
        }
    }

    public static boolean isMixedParticleRenderingSetting() {
        return mixedParticleRenderingSetting;
    }

    private static ParticleRenderingSettings getParticleRenderingSettings0() {
        return Iris.getPipelineManager().getPipeline().map(WorldRenderingPipeline::getParticleRenderingSettings).orElse(ParticleRenderingSettings.MIXED);
    }

    private static void resetBTesselators() {
        BTESSELATORS.values().forEach(BindingTesselator::clear);
    }

    private static void closeBTesselators() {
        Iterator<BindingTesselator> iterator = BTESSELATORS.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().close();
            iterator.remove();
        }
    }

    @NotNull
    public static class_287 beginBufferBuilder(class_3999 particleRenderType) {
        return BTESSELATORS.computeIfAbsent(particleRenderType, AsyncRenderer::computeBTesselator).begin();
    }

    @NotNull
    private static BindingTesselator computeBTesselator(class_3999 particleRenderType) {
        class_1921 renderType = particleRenderType.comp_3341();
        if (renderType == null) {
            return BindingTesselator.EMPTY;
        }
        return new BindingTesselator(256, renderType.method_23033(), renderType.method_23031());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markAsSync(Class<? extends class_703> aClass) {
        Set<Class<? extends class_703>> set = SYNC_PARTICLE_TYPES;
        synchronized (set) {
            SYNC_PARTICLE_TYPES.add(aClass);
        }
    }

    public static boolean shouldSync(Class<? extends class_703> aClass) {
        return SYNC_PARTICLE_TYPES.contains(aClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recordSync(class_3999 particleRenderType, class_703 particle) {
        Set particles;
        Set set = particles = SYNC_PARTICLES.computeIfAbsent(particleRenderType, k -> Collections.newSetFromMap(new IdentityHashMap()));
        synchronized (set) {
            particles.add(particle);
        }
    }

    public static Set<class_703> getSync(class_3999 particleRenderType) {
        Set<class_703> set = SYNC_PARTICLES.get(particleRenderType);
        return set == null ? Collections.emptySet() : set;
    }

    private static void clearSync() {
        SYNC_PARTICLES.clear();
    }

    public static void debugLater(Consumer<String> consumer) {
        debugConsumer = consumer;
    }

    static void tryDebug() {
        if (debugConsumer != null) {
            debugConsumer.accept("[Debug AsyncRenderer]\nasync queue size: %d,\nbuffer capacity: %s,\nrender order: %s,\nsync particle count: %d,\nsync particle types: %s,\nsync particle render types: %s,\niris particle state: %s".formatted(asyncTasksSize, BTESSELATORS.entrySet().stream().filter(e -> ((BindingTesselator)e.getValue()).buffer != null).collect(Collectors.toMap(e -> ((class_3999)e.getKey()).comp_3340(), e -> ((BindingTesselator)e.getValue()).buffer.field_52083)), ModListHelper.IS_FORGE ? class_310.method_1551().field_1713.field_3830.keySet().stream().map(class_3999::comp_3340).toList() : class_702.field_17820.stream().map(class_3999::comp_3340).toList(), SYNC_PARTICLES.values().stream().mapToInt(Set::size).sum(), SYNC_PARTICLE_TYPES.stream().map(Class::getName).toList(), BTESSELATORS.entrySet().stream().filter(e -> e.getValue() == BindingTesselator.EMPTY).map(p -> ((class_3999)p.getKey()).comp_3340()).toList(), ModListHelper.IRIS_LIKE_LOADED && IrisApi.getInstance().isShaderPackInUse() ? AsyncRenderer.getParticleRenderingSettings0().name() : "disabled"));
            debugConsumer = null;
        }
    }

    public static void reset() {
        AsyncRenderer.waitForAsyncTasks();
        AsyncRenderer.closeBTesselators();
        AsyncRenderer.clearSync();
    }

    public static boolean isTranslucentPhase(Object phase) {
        return phase == ParticleRenderingPhase.TRANSLUCENT;
    }

    public static boolean isOpaquePhase(Object phase) {
        return phase == ParticleRenderingPhase.OPAQUE;
    }

    static {
        SYNC_PARTICLE_TYPES.add(class_693.class);
        SYNC_PARTICLE_TYPES.add(class_700.class);
        if (ModListHelper.DUMMMMMMY_LOADED) {
            AsyncRenderer.addSyncByClassName("net.mehvahdjukaar.dummmmmmy.client.DamageNumberParticle");
        }
        if (ModListHelper.FABRIC_EFFECTIVE_LOADED) {
            AsyncRenderer.addSyncByClassName("org.ladysnake.effective.particle.SplashParticle");
        }
        if (ModListHelper.FORGE_EFFECTIVE_LOADED) {
            AsyncRenderer.addSyncByClassName("concerrox.effective.particle.SplashParticle");
        }
        if (ModListHelper.TOMBSTONE_LOADED) {
            AsyncRenderer.addSyncByClassName("ovh.corail.tombstone.particle.ParticleCasting");
            AsyncRenderer.addSyncByClassName("ovh.corail.tombstone.particle.ParticleGhost");
            AsyncRenderer.addSyncByClassName("ovh.corail.tombstone.particle.ParticleGraveSoul");
            AsyncRenderer.addSyncByClassName("ovh.corail.tombstone.particle.ParticleMagicCircle");
            AsyncRenderer.addSyncByClassName("ovh.corail.tombstone.particle.ParticleMarker");
            AsyncRenderer.addSyncByClassName("ovh.corail.tombstone.particle.ParticleRounding");
        }
        SYNC_PARTICLES = Collections.synchronizedMap(new IdentityHashMap());
        AtomicInteger workerCount = new AtomicInteger(1);
        int clamp = class_3532.method_15340((int)(Runtime.getRuntime().availableProcessors() - 1), (int)1, (int)6);
        EXECUTOR = new ForkJoinPool(clamp, forkJoinPool -> {
            ForkJoinWorkerThread forkJoinWorkerThread = new ForkJoinWorkerThread(forkJoinPool){

                @Override
                protected void onTermination(Throwable throwable) {
                    if (throwable != null) {
                        LOGGER.warn("{} died", (Object)this.getName(), (Object)throwable);
                    } else {
                        LOGGER.debug("{} shutdown", (Object)this.getName());
                    }
                    super.onTermination(throwable);
                }
            };
            forkJoinWorkerThread.setName("AsyncParticleRenderer-" + workerCount.getAndIncrement());
            forkJoinWorkerThread.setDaemon(true);
            return forkJoinWorkerThread;
        }, class_156::method_18347, true);
        EXCEPTION_TRACKER = new ExceptionTracker(() -> 5000, () -> SimplePropertiesConfig.renderFailurePerSecondThreshold);
        BTESSELATORS = new IdentityHashMap<class_3999, BindingTesselator>();
    }
}

