/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client;

import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.AsyncRenderer;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.AsyncparticlesClient;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.addon.LightCachedParticleAddon;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleAddon;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.compat.ModListHelper;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.compat.a_good_place.AGoodPlaceCompat;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.compat.particlerain.ParticleRainCompat;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.config.SimplePropertiesConfig;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.BusyWaitEvictingQueue;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionTracker;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionUtil;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.IterationSafeEvictingQueue;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.LongRef;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TrackingEmitter;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.chunk.MissingPaletteEntryException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class AsyncTicker {
    public static final Logger LOGGER = LogManager.getLogger();
    private static final Set<Class<? extends Particle>> SYNC_PARTICLE_TYPES = Collections.newSetFromMap(new IdentityHashMap());
    private static final Set<Particle> SYNC_PARTICLES = Collections.newSetFromMap(new IdentityHashMap());
    public static final List<Runnable> BLOCK_ENTITY_OPERATIONS = new ArrayList<Runnable>();
    public static final List<Runnable> PARTICLE_OPERATIONS = new ArrayList<Runnable>();
    private static boolean cancelled = false;
    public static boolean shouldTickParticles = false;
    public static CompletableFuture<Void> particleCleanup;
    private static final List<Runnable> END_TICK_EVENTS;
    private static final List<Pair<ResourceLocation, Runnable>> END_TICK_OPERATIONS;
    private static CompletableFuture<Void> particleFuture;
    private static CompletableFuture<Void> blockEntityTickFuture;
    private static boolean debug_cancelled;
    private static Consumer<String> debugConsumer;
    private static boolean shouldReload;
    public static final ExecutorService EXECUTOR;
    public static final String THREAD_PREFIX = "AsyncParticleTicker";
    private static final ExceptionTracker<Object> EXCEPTION_TRACKER;
    private static final LongRef timeUsageNano;

    private static void addSyncByClassName(String className) {
        try {
            SYNC_PARTICLE_TYPES.add(Class.forName(className));
        }
        catch (Exception e) {
            LOGGER.warn("", (Throwable)e);
        }
    }

    public static boolean isCancelled() {
        if (!cancelled) {
            return false;
        }
        debug_cancelled = true;
        return true;
    }

    public static void onRunAllTasks() {
        if (!SimplePropertiesConfig.isTickAsync()) {
            return;
        }
        if (blockEntityTickFuture != null && !SimplePropertiesConfig.greedyAsyncClientBlockEntityTick()) {
            blockEntityTickFuture.join();
            blockEntityTickFuture = null;
        }
    }

    public static void onTickBefore(int i, int to) {
        boolean levelRunning;
        if (!SimplePropertiesConfig.isTickAsync()) {
            return;
        }
        ProfilerFiller profiler = Profiler.get();
        profiler.push("async_particles");
        if (blockEntityTickFuture != null && (i != 0 || SimplePropertiesConfig.greedyAsyncClientBlockEntityTick())) {
            blockEntityTickFuture.join();
            blockEntityTickFuture = null;
        }
        Minecraft mc = Minecraft.getInstance();
        boolean bl = levelRunning = mc.level != null && mc.player != null && !mc.isPaused();
        if (i != 0) {
            shouldTickParticles = i == to - 1 && levelRunning;
        } else {
            cancelled = true;
            debug_cancelled = false;
            if (particleFuture != null) {
                particleFuture.join();
                particleFuture = null;
            }
            cancelled = false;
            boolean bl2 = shouldTickParticles = i == to - 1 && levelRunning;
            if (levelRunning) {
                ParticleEngine particleEngine = mc.particleEngine;
                Collection values = particleEngine.particles.values();
                CompletableFuture[] futures = new CompletableFuture[values.size() + 1];
                int k = 0;
                Queue trackingEmitters = particleEngine.trackingEmitters;
                futures[k++] = trackingEmitters.isEmpty() ? CompletableFuture.completedFuture(null) : CompletableFuture.runAsync(() -> trackingEmitters.removeIf(trackingEmitter -> !trackingEmitter.isAlive()), EXECUTOR);
                for (Queue particles : values) {
                    if (particles.isEmpty()) {
                        futures[k++] = CompletableFuture.completedFuture(null);
                        continue;
                    }
                    futures[k++] = CompletableFuture.runAsync(() -> particles.removeIf(particle1 -> {
                        boolean b;
                        boolean bl = ((ParticleAddon)particle1).asyncparticles$isTickSync() ? !particle1.isAlive() : (b = ((ParticleAddon)particle1).asyncparticles$shouldRemove());
                        if (b) {
                            particle1.getParticleGroup().ifPresent(group -> particleEngine.updateCount(group, -1));
                            return true;
                        }
                        return false;
                    }), EXECUTOR);
                }
                particleCleanup = CompletableFuture.allOf(futures);
            }
        }
        profiler.pop();
    }

    public static void onTickAfter(int i, int to) {
        List<Runnable> particleOperations;
        List<Pair<ResourceLocation, Runnable>> endTickOperations;
        CompletionStage<Void> particleFuture;
        boolean levelRunning;
        if (!SimplePropertiesConfig.isTickAsync()) {
            AsyncTicker.tryReload();
            AsyncTicker.tryDebug();
            END_TICK_OPERATIONS.forEach(p -> ((Runnable)p.second()).run());
            END_TICK_OPERATIONS.clear();
            END_TICK_EVENTS.forEach(Runnable::run);
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        ProfilerFiller profiler = Profiler.get();
        profiler.push("async_particles");
        boolean bl = levelRunning = mc.level != null && mc.player != null && !mc.isPaused();
        if (levelRunning) {
            profiler.push("particle_tick");
            if (i == to - 1) {
                mc.particleEngine.tick();
            } else {
                AsyncTicker.waitForCleanUp();
            }
            profiler.pop();
        }
        if (i != to - 1) {
            return;
        }
        AsyncTicker.tryReload();
        AsyncTicker.tryDebug();
        List<Runnable> blockEntityOperations = BLOCK_ENTITY_OPERATIONS;
        if (!levelRunning || !SimplePropertiesConfig.asyncBlockEntityTick()) {
            particleFuture = CompletableFuture.runAsync(() -> timeUsageNano.set(System.nanoTime()), EXECUTOR);
            if (!blockEntityOperations.isEmpty()) {
                blockEntityOperations.clear();
            }
        } else {
            Runnable[] blockEntityTasks = blockEntityOperations.toArray(new Runnable[0]);
            blockEntityOperations.clear();
            particleFuture = CompletableFuture.runAsync(() -> {
                timeUsageNano.set(System.nanoTime());
                for (Runnable blockEntityTask : blockEntityTasks) {
                    blockEntityTask.run();
                }
            }, EXECUTOR).exceptionally(AsyncTicker::tickExceptionally);
            blockEntityTickFuture = particleFuture;
        }
        if (levelRunning) {
            particleFuture = ((CompletableFuture)((CompletableFuture)particleFuture).thenRun(() -> {
                for (Runnable endTickEvent : END_TICK_EVENTS) {
                    try {
                        endTickEvent.run();
                    }
                    catch (Exception e) {
                        if (AsyncTicker.isTolerable(e) && !EXCEPTION_TRACKER.addException(endTickEvent, e)) continue;
                        throw e;
                    }
                }
            })).exceptionally(AsyncTicker::tickExceptionally);
        }
        if (!(endTickOperations = END_TICK_OPERATIONS).isEmpty()) {
            Pair[] endTickTasks = endTickOperations.toArray(new Pair[0]);
            endTickOperations.clear();
            particleFuture = ((CompletableFuture)((CompletableFuture)particleFuture).thenRun(() -> {
                for (Pair endTickTask : endTickTasks) {
                    try {
                        ((Runnable)endTickTask.second()).run();
                    }
                    catch (Exception e) {
                        if (AsyncTicker.isTolerable(e) && !EXCEPTION_TRACKER.addException(endTickTask.first(), e)) continue;
                        throw e;
                    }
                }
            })).exceptionally(AsyncTicker::tickExceptionally);
        }
        if (!(particleOperations = PARTICLE_OPERATIONS).isEmpty()) {
            Runnable[] particleTasks = particleOperations.toArray(new Runnable[0]);
            particleOperations.clear();
            particleFuture = ((CompletableFuture)((CompletableFuture)particleFuture).thenCompose(v -> CompletableFuture.allOf((CompletableFuture[])Arrays.stream(particleTasks).map(runnable -> CompletableFuture.runAsync(runnable, EXECUTOR).exceptionally(e -> {
                if (!SimplePropertiesConfig.markSyncIfTickFailed() && AsyncTicker.isTolerable(e)) {
                    LOGGER.warn("Exception while executing particle operation, you can ignore it if it doesn't happen frequently.", e);
                    return null;
                }
                throw ExceptionUtil.toThrowDirectly(e);
            })).toArray(CompletableFuture[]::new)))).thenRun(() -> timeUsageNano.set(System.nanoTime() - timeUsageNano.get()));
        }
        AsyncTicker.particleFuture = particleFuture;
        profiler.pop();
    }

    private static Void tickExceptionally(Throwable e) {
        if (!(e instanceof Exception)) {
            throw ExceptionUtil.toThrowDirectly(e);
        }
        Minecraft mc = Minecraft.getInstance();
        if (!AsyncTicker.isTolerable(e) && mc.level != null && mc.player != null) {
            throw ExceptionUtil.toThrowDirectly(e);
        }
        LOGGER.warn("Exception while executing before particle operation", e);
        return null;
    }

    public static void onTickingParticleException(Particle particle, Throwable t) {
        boolean tolerable = AsyncTicker.isTolerable(t);
        if (tolerable && !EXCEPTION_TRACKER.addException(particle.getClass(), t)) {
            return;
        }
        if (SimplePropertiesConfig.markSyncIfTickFailed()) {
            ((ParticleAddon)particle).asyncparticles$setTickSync();
            if (!AsyncTicker.shouldSync(particle.getClass())) {
                if (!tolerable) {
                    LOGGER.warn("Exception while ticking particle {}, marking as sync", (Object)particle, (Object)t);
                } else {
                    LOGGER.warn("Exception {} thrown while ticking particle {} exceeds the threshold, please contact the author: {}", (Object)t.getClass().getSimpleName(), (Object)particle, (Object)"https://github.com/Harveykang/AsyncParticles/issues", (Object)t);
                }
                AsyncTicker.markAsSync(particle.getClass());
            }
            AsyncTicker.recordSync(particle);
        } else if (tolerable) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null) {
                player.displayClientMessage((Component)Component.literal((String)"Exception %s thrown while ticking particle %s exceeds the threshold, please contact the author: ".formatted(t.getClass().getSimpleName(), particle.getClass())).append((Component)Component.literal((String)"https://github.com/Harveykang/AsyncParticles/issues").setStyle(Style.EMPTY.withClickEvent((ClickEvent)new ClickEvent.OpenUrl(AsyncparticlesClient.ISSUE_URI)).withUnderlined(Boolean.valueOf(true)))), false);
            }
            LOGGER.warn("Exception {} thrown while ticking particle {} exceeds the threshold, please contact the author: {}", (Object)t.getClass().getSimpleName(), (Object)particle, (Object)"https://github.com/Harveykang/AsyncParticles/issues", (Object)t);
        } else {
            throw AsyncTicker.constructCrashReport(particle, t);
        }
    }

    public static boolean isTolerable(@NotNull Throwable e) {
        if (!(e instanceof Exception)) {
            return false;
        }
        Throwable rootCause = ExceptionUtil.getRootCause(e);
        return rootCause instanceof MissingPaletteEntryException || rootCause instanceof NullPointerException || rootCause instanceof IndexOutOfBoundsException || rootCause instanceof ArrayIndexOutOfBoundsException || rootCause instanceof ConcurrentModificationException && SimplePropertiesConfig.suppressCME();
    }

    public static void onParticleEngineClear() {
        if (ModListHelper.A_GOOD_PLACE_LOADED) {
            AGoodPlaceCompat.onParticleEngineClear();
        }
        if (ModListHelper.PARTICLERAIN_LOADED) {
            ParticleRainCompat.clearCounters();
        }
    }

    public static void waitForCleanUp() {
        if (particleCleanup != null) {
            particleCleanup.join();
            particleCleanup = null;
        }
    }

    public static ReportedException constructCrashReport(Particle particle, Throwable t) {
        AsyncTicker.debugLater(arg_0 -> ((Logger)LOGGER).info(arg_0));
        AsyncTicker.tryDebug();
        AsyncRenderer.debugLater(arg_0 -> ((Logger)LOGGER).info(arg_0));
        AsyncRenderer.tryDebug();
        CrashReport crashReport = CrashReport.forThrowable((Throwable)t, (String)"Ticking Particle");
        CrashReportCategory crashReportCategory = crashReport.addCategory("Particle being ticked");
        crashReportCategory.setDetail("Particle", () -> ((Particle)particle).toString());
        crashReportCategory.setDetail("Particle Type", () -> ((ParticleRenderType)particle.getRenderType()).toString());
        return new ReportedException(crashReport);
    }

    public static void tickSyncParticles() {
        if (!shouldTickParticles && SimplePropertiesConfig.isTickAsync() || SYNC_PARTICLES.isEmpty()) {
            return;
        }
        ParticleEngine particleEngine = Minecraft.getInstance().particleEngine;
        Iterator<Particle> iterator = SYNC_PARTICLES.iterator();
        while (iterator.hasNext()) {
            Particle particle = iterator.next();
            try {
                particleEngine.tickParticle(particle);
                if (!(particle instanceof TrackingEmitter)) {
                    if (particle instanceof LightCachedParticleAddon) {
                        LightCachedParticleAddon lightCachedParticle = (LightCachedParticleAddon)particle;
                        if (SimplePropertiesConfig.particleLightCache()) {
                            lightCachedParticle.asyncparticles$refresh();
                        }
                    }
                    ((ParticleAddon)particle).asyncparticles$setTicked();
                }
            }
            catch (Throwable e) {
                throw AsyncTicker.constructCrashReport(particle, e);
            }
            if (particle.isAlive()) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markAsSync(Class<? extends Particle> aClass) {
        Set<Class<? extends Particle>> set = SYNC_PARTICLE_TYPES;
        synchronized (set) {
            SYNC_PARTICLE_TYPES.add(aClass);
        }
    }

    public static boolean shouldSync(Class<? extends Particle> aClass) {
        return SYNC_PARTICLE_TYPES.contains(aClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recordSync(Particle particle) {
        Set<Particle> set = SYNC_PARTICLES;
        synchronized (set) {
            SYNC_PARTICLES.add(particle);
        }
    }

    public static void onEvicted(Particle particle) {
        particle.getParticleGroup().ifPresent(g -> Minecraft.getInstance().particleEngine.updateCount(g, -1));
        if (particle.isAlive()) {
            particle.remove();
        }
    }

    static void tryDebug() {
        if (debugConsumer == null) {
            return;
        }
        debugConsumer.accept(String.format("[Debug AsyncTicker]\nlast tick duration: %.1f ms,\ninterrupted: %s,\nblock entity operations: %d,\nparticle operations: %d,\nend tick events: %d,\nend tick operations: %d,\nmax particles queue size: %d,\nparticles queue size/allocated: %s,\nparticles to add size: %d\nsync particle count: %d,\nsync particle types: %s,".formatted(SimplePropertiesConfig.isTickAsync() ? (double)timeUsageNano.get() / 1000000.0 : Double.NaN, debug_cancelled, BLOCK_ENTITY_OPERATIONS.size(), PARTICLE_OPERATIONS.size(), END_TICK_EVENTS.size(), END_TICK_OPERATIONS.size(), SimplePropertiesConfig.getLimit(), Minecraft.getInstance().particleEngine.particles.entrySet().stream().collect(Collectors.toMap(e -> ((ParticleRenderType)e.getKey()).name(), e -> {
            Queue queue = (Queue)e.getValue();
            return queue.size() + "/" + ((IterationSafeEvictingQueue)queue).arraySize();
        })), Minecraft.getInstance().particleEngine.particlesToAdd.size(), SYNC_PARTICLES.size(), SYNC_PARTICLE_TYPES.stream().map(Class::getName).toList()), new Object[0]));
        debugConsumer = null;
    }

    public static void debugLater(Consumer<String> consumer) {
        debugConsumer = consumer;
    }

    public static void dumpParticles() {
        LOGGER.info((Object)Minecraft.getInstance().particleEngine.particles);
    }

    public static void reloadLater() {
        shouldReload = true;
    }

    private static void tryReload() {
        if (shouldReload) {
            AsyncTicker.reload(false);
            shouldReload = false;
        }
    }

    public static void reload(boolean clearParticles) {
        AsyncRenderer.reset();
        ParticleEngine particleEngine = Minecraft.getInstance().particleEngine;
        if (clearParticles) {
            AsyncTicker.reset();
            particleEngine.clearParticles();
        } else {
            BusyWaitEvictingQueue<Particle> newToAdd = new BusyWaitEvictingQueue<Particle>(1024, SimplePropertiesConfig.getLimit(), AsyncTicker::onEvicted);
            newToAdd.addAll(particleEngine.particlesToAdd);
            particleEngine.particlesToAdd = newToAdd;
            BusyWaitEvictingQueue<TrackingEmitter> newEmitters = new BusyWaitEvictingQueue<TrackingEmitter>(256, SimplePropertiesConfig.getLimit(), AsyncTicker::onEvicted);
            newEmitters.addAll(particleEngine.trackingEmitters);
            particleEngine.trackingEmitters = newEmitters;
            particleEngine.particles.entrySet().forEach(entry -> {
                Queue queue = (Queue)entry.getValue();
                IterationSafeEvictingQueue<Particle> newQueue = new IterationSafeEvictingQueue<Particle>(16, SimplePropertiesConfig.getLimit(), AsyncTicker::onEvicted);
                newQueue.addAll(queue);
                entry.setValue(newQueue);
            });
        }
    }

    public static void reset() {
        cancelled = true;
        AsyncTicker.waitForCleanUp();
        if (blockEntityTickFuture != null) {
            blockEntityTickFuture.join();
            blockEntityTickFuture = null;
        }
        if (particleFuture != null) {
            particleFuture.join();
            particleFuture = null;
        }
        BLOCK_ENTITY_OPERATIONS.clear();
        PARTICLE_OPERATIONS.clear();
        END_TICK_OPERATIONS.clear();
        SYNC_PARTICLES.clear();
        cancelled = false;
    }

    public static void registerEndTickEvent(MinecraftConsumer consumer) {
        AsyncTicker.registerEndTickEvent(() -> consumer.accept(Minecraft.getInstance()));
    }

    public static void registerEndTickEvent(ClientLevelConsumer consumer) {
        AsyncTicker.registerEndTickEvent(() -> consumer.accept(Minecraft.getInstance().level));
    }

    public static void registerEndTickEvent(Runnable operation) {
        END_TICK_EVENTS.add(operation);
    }

    public static void addEndTickTask(ResourceLocation resourceLocation, MinecraftConsumer consumer) {
        AsyncTicker.addEndTickTask(resourceLocation, () -> consumer.accept(Minecraft.getInstance()));
    }

    public static void addEndTickTask(ResourceLocation resourceLocation, ClientLevelConsumer consumer) {
        AsyncTicker.addEndTickTask(resourceLocation, () -> consumer.accept(Minecraft.getInstance().level));
    }

    public static void addEndTickTask(ResourceLocation resourceLocation, Runnable operation) {
        if (shouldTickParticles || !SimplePropertiesConfig.isTickAsync()) {
            END_TICK_OPERATIONS.add((Pair<ResourceLocation, Runnable>)Pair.of((Object)resourceLocation, (Object)operation));
        }
    }

    static {
        END_TICK_EVENTS = new ArrayList<Runnable>();
        END_TICK_OPERATIONS = new ArrayList<Pair<ResourceLocation, Runnable>>();
        debug_cancelled = false;
        EXCEPTION_TRACKER = new ExceptionTracker(() -> 5000, () -> SimplePropertiesConfig.tickFailurePerSecondThreshold);
        timeUsageNano = new LongRef(0L);
        AtomicInteger workerCount = new AtomicInteger(1);
        int clamp = Mth.clamp((int)(Runtime.getRuntime().availableProcessors() - 1), (int)1, (int)6);
        EXECUTOR = new ForkJoinPool(clamp, forkJoinPool -> {
            ForkJoinWorkerThread forkJoinWorkerThread = new ForkJoinWorkerThread(forkJoinPool){

                @Override
                protected void onTermination(Throwable throwable) {
                    if (throwable != null) {
                        LOGGER.warn("{} died", (Object)this.getName(), (Object)throwable);
                    } else {
                        LOGGER.debug("{} shutdown", (Object)this.getName());
                    }
                    super.onTermination(throwable);
                }
            };
            forkJoinWorkerThread.setName("AsyncParticleTicker-" + workerCount.getAndIncrement());
            forkJoinWorkerThread.setDaemon(true);
            return forkJoinWorkerThread;
        }, Util::onThreadException, true);
    }

    @FunctionalInterface
    public static interface MinecraftConsumer {
        public void accept(Minecraft var1);
    }

    @FunctionalInterface
    public static interface ClientLevelConsumer {
        public void accept(ClientLevel var1);
    }
}

