/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client.mixin.neoforge;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.function.Predicate;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.AsyncRenderer;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleAddon;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.config.SimplePropertiesConfig;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.FrustumUtil;
import net.minecraft.client.Camera;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ParticleEngine.class}, priority=500)
public abstract class MixinParticleEngine_Render {
    @Shadow
    @Final
    public Map<ParticleRenderType, Queue<Particle>> particles;
    private Enum<?> phase;

    @Overwrite(remap=false)
    private static void renderParticleType(Camera camera, float f, MultiBufferSource.BufferSource bufferSource, ParticleRenderType particleRenderType, Queue<Particle> particles, @Nullable Frustum frustum) {
        VertexConsumer vertexconsumer = bufferSource.getBuffer(Objects.requireNonNull(particleRenderType.renderType()));
        if (frustum == null) {
            frustum = AsyncRenderer.frustum;
        }
        float f2 = f + 1.0f;
        for (Particle particle : particles) {
            float f3;
            if (!particle.isAlive()) continue;
            float f4 = f3 = ((ParticleAddon)particle).asyncparticles$isTicked() ? f : f2;
            if (SimplePropertiesConfig.isCullParticles() && !FrustumUtil.isVisible(frustum, particle.getRenderBoundingBox(f3))) continue;
            if (((ParticleAddon)particle).asyncparticles$isRenderSync()) {
                AsyncRenderer.recordSync(particleRenderType, particle);
                continue;
            }
            try {
                particle.render(vertexconsumer, camera, f3);
            }
            catch (Throwable t) {
                throw AsyncRenderer.constructCrashReport(particle, particleRenderType, t);
            }
        }
    }

    @Overwrite(remap=false)
    public static void renderCustomParticles(Camera camera, float f, MultiBufferSource.BufferSource bufferSource, Queue<Particle> particles, Frustum frustum) {
        PoseStack poseStack = new PoseStack();
        if (frustum == null) {
            frustum = AsyncRenderer.frustum;
        }
        float f2 = f + 1.0f;
        for (Particle particle : particles) {
            float f3;
            if (!particle.isAlive()) continue;
            float f4 = f3 = ((ParticleAddon)particle).asyncparticles$isTicked() ? f : f2;
            if (SimplePropertiesConfig.isCullParticles() && !FrustumUtil.isVisible(frustum, particle.getRenderBoundingBox(f3))) continue;
            try {
                particle.renderCustom(poseStack, (MultiBufferSource)bufferSource, camera, f3);
            }
            catch (Throwable t) {
                throw AsyncRenderer.constructCrashReport(particle, particle.getRenderType(), t);
            }
        }
    }

    @Overwrite(remap=false)
    public void render(Camera camera, float partialTick, MultiBufferSource.BufferSource bufferSource, @Nullable Frustum frustum, Predicate<ParticleRenderType> renderTypePredicate) {
        Queue<Particle> queue2;
        Set<ParticleRenderType> renderOrder = this.particles.keySet();
        if (SimplePropertiesConfig.isRenderAsync()) {
            AsyncRenderer.endAll(camera, partialTick, renderTypePredicate, renderOrder);
        } else {
            for (ParticleRenderType particleRenderType : renderOrder) {
                Queue<Particle> queue;
                if (particleRenderType.renderType() == null || !renderTypePredicate.test(particleRenderType) || (queue = this.particles.get(particleRenderType)) == null || queue.isEmpty()) continue;
                MixinParticleEngine_Render.renderParticleType(camera, partialTick, bufferSource, particleRenderType, queue, frustum);
            }
        }
        if (renderTypePredicate.test(ParticleRenderType.PARTICLE_SHEET_OPAQUE) && (queue2 = this.particles.get(ParticleRenderType.CUSTOM)) != null && !queue2.isEmpty()) {
            MixinParticleEngine_Render.renderCustomParticles(camera, partialTick, bufferSource, queue2, frustum);
        }
        bufferSource.endBatch();
    }
}

