/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client.mixin.tick;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.List;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.AsyncTicker;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={Level.class})
public class MixinLevel {
    @Shadow
    @Final
    public boolean isClientSide;
    @Shadow
    @Final
    public List<TickingBlockEntity> pendingBlockEntityTickers;
    @Shadow
    @Final
    protected List<TickingBlockEntity> blockEntityTickers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"tickBlockEntities"}, at=@At(value="INVOKE", target="Ljava/util/List;isEmpty()Z"))
    private boolean onTickBlockEntities(List<?> instance) {
        if (!this.isClientSide) {
            return instance.isEmpty();
        }
        if (!this.pendingBlockEntityTickers.isEmpty()) {
            List<TickingBlockEntity> list = this.pendingBlockEntityTickers;
            synchronized (list) {
                if (!this.pendingBlockEntityTickers.isEmpty()) {
                    this.blockEntityTickers.addAll(this.pendingBlockEntityTickers);
                    this.pendingBlockEntityTickers.clear();
                }
            }
        }
        return true;
    }

    @WrapOperation(method={"tickBlockEntities"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/TickingBlockEntity;tick()V")})
    private void onTickBlockEntity(TickingBlockEntity instance, Operation<Void> original) {
        if (!this.isClientSide) {
            original.call(new Object[]{instance});
            return;
        }
        try {
            original.call(new Object[]{instance});
        }
        catch (Exception e) {
            if (!AsyncTicker.isTolerable(e)) {
                throw e;
            }
            AsyncTicker.LOGGER.warn("Exception while ticking block entity {}", (Object)instance, (Object)e);
        }
    }
}

