/*
 * Decompiled with CFR 0.152.
 */
package fabric.fun.qu_an.minecraft.asyncparticles.client.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import fabric.fun.qu_an.minecraft.asyncparticles.client.AsyncTicker;
import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.ModListHelper;
import fabric.fun.qu_an.minecraft.asyncparticles.client.config.ClothConfigMenus;
import fabric.fun.qu_an.minecraft.asyncparticles.client.config.FailBehavior;
import fabric.fun.qu_an.minecraft.asyncparticles.client.config.FallbackScreen;
import fabric.fun.qu_an.minecraft.asyncparticles.client.config.LegacyConfigMigrator;
import fabric.fun.qu_an.minecraft.asyncparticles.client.config.RainEffect;
import fabric.fun.qu_an.minecraft.asyncparticles.client.config.RenderingMode;
import fabric.fun.qu_an.minecraft.asyncparticles.client.config.TickMode;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_410;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;

public class AsyncParticlesConfig {
    public static final int VERSION = 1;
    public static final Path CONFIG_FILE = Path.of("config", "asyncparticles", "asyncparticles.json");
    static final Gson GSON = new GsonBuilder().setLenient().setPrettyPrinting().disableHtmlEscaping().create();
    static final Logger LOGGER = LogUtils.getLogger();
    public static int particle$particleLimit;
    public static boolean particle$removeIfMissedTick;
    public static boolean particle$particleLightCache;
    public static boolean particle$cullUnderwaterParticleType;
    public static TickMode tick$animationTickMode;
    public static TickMode tick$particleTickMode;
    public static int tick$failPerSecLimit;
    public static FailBehavior tick$failBehavior;
    public static boolean tick$suppressCME;
    public static boolean rendering$cullParticles;
    public static RenderingMode rendering$particleRenderingMode;
    public static int rendering$failPerSecLimit;
    public static FailBehavior rendering$failBehavior;
    public static RainEffect valkyrienSkies$rainEffect;
    public static boolean valkyrienSkies$fixParticleLights;
    public static RainEffect create$rainEffect;

    public static class_437 newConfigScreen(class_437 parent) {
        if (ModListHelper.CLOTH_CONFIG_LOADED) {
            return ClothConfigMenus.screenBuilder(parent).build();
        }
        return AsyncParticlesConfig.fallBackScreen(parent);
    }

    private static class_437 fallBackScreen(class_437 parent) {
        FallbackScreen fallbackScreen = new FallbackScreen(parent, (class_2561)class_2561.method_43471((String)"gui.asyncparticles.menu-unavailable"), (class_2561)class_2561.method_43471((String)"gui.asyncparticles.menu-unavailable.message"), (class_2561)class_2561.method_43471((String)"gui.back"), current -> class_310.method_1551().method_1507(current.parent), (class_2561)class_2561.method_43471((String)"gui.asyncparticles.reload"), current -> class_310.method_1551().method_1507((class_437)new class_410(b -> {
            class_5250 msg = class_2561.method_43471((String)"gui.asyncparticles.menu-unavailable.message");
            if (!b) {
                current.message = msg;
                class_310.method_1551().method_1507((class_437)current);
                return;
            }
            try {
                AsyncParticlesConfig.load();
            }
            catch (Exception e) {
                current.message = msg.method_27693("\n").method_10852((class_2561)class_2561.method_43469((String)"gui.asyncparticles.failed-to-reload", (Object[])new Object[]{e.toString()}).method_27692(class_124.field_1079));
                class_310.method_1551().method_1507((class_437)current);
                return;
            }
            finally {
                AsyncTicker.reloadLater();
            }
            current.message = msg.method_27693("\n").method_10852((class_2561)class_2561.method_43471((String)"gui.asyncparticles.reload-successfully").method_27692(class_124.field_1077));
            class_310.method_1551().method_1507((class_437)current);
        }, (class_2561)class_2561.method_43471((String)"gui.asyncparticles.menu-unavailable"), (class_2561)class_2561.method_43471((String)"gui.asyncparticles.reload-confirmation"))));
        BiConsumer[] tickCallbacks = new BiConsumer[2];
        Consumer<FallbackScreen> reloadCallback = fallbackScreen.buttonRightCallback;
        tickCallbacks[0] = (fs, br) -> {
            if (!class_437.method_25442()) {
                return;
            }
            br.method_25355((class_2561)class_2561.method_43471((String)"gui.asyncparticles.reset").method_27692(class_124.field_1061));
            fs.buttonRightTick = tickCallbacks[1];
            fs.buttonRightCallback = current -> class_310.method_1551().method_1507((class_437)new class_410(b -> {
                class_5250 msg = class_2561.method_43471((String)"gui.asyncparticles.menu-unavailable.message");
                if (!b) {
                    current.message = msg;
                    class_310.method_1551().method_1507((class_437)current);
                    return;
                }
                try {
                    AsyncParticlesConfig.reset();
                }
                catch (Exception e) {
                    current.message = msg.method_27693("\n").method_10852((class_2561)class_2561.method_43469((String)"gui.asyncparticles.failed-to-reset", (Object[])new Object[]{e.toString()}).method_27692(class_124.field_1079));
                    class_310.method_1551().method_1507((class_437)current);
                    return;
                }
                finally {
                    AsyncTicker.reloadLater();
                }
                current.message = msg.method_27693("\n").method_10852((class_2561)class_2561.method_43471((String)"gui.asyncparticles.reset-successfully").method_27692(class_124.field_1077));
                class_310.method_1551().method_1507((class_437)current);
            }, (class_2561)class_2561.method_43471((String)"gui.asyncparticles.menu-unavailable"), (class_2561)class_2561.method_43471((String)"gui.asyncparticles.reset-confirmation").method_27692(class_124.field_1061)));
        };
        tickCallbacks[1] = (fs, br) -> {
            if (class_437.method_25442()) {
                return;
            }
            br.method_25355((class_2561)class_2561.method_43471((String)"gui.asyncparticles.reload"));
            fs.buttonRightTick = tickCallbacks[0];
            fs.buttonRightCallback = reloadCallback;
        };
        fallbackScreen.buttonRightTick = tickCallbacks[0];
        return fallbackScreen;
    }

    public static void load() throws IOException, JsonParseException {
        ConfigObj configObj;
        if (!Files.exists(CONFIG_FILE, new LinkOption[0])) {
            Files.createDirectories(CONFIG_FILE.getParent(), new FileAttribute[0]);
            Files.createFile(CONFIG_FILE, new FileAttribute[0]);
            new ConfigObj().flat();
            if (LegacyConfigMigrator.migrate()) {
                AsyncParticlesConfig.save();
            } else {
                AsyncParticlesConfig.reset();
            }
            return;
        }
        try (BufferedReader json = Files.newBufferedReader(CONFIG_FILE);){
            configObj = (ConfigObj)GSON.fromJson((Reader)json, ConfigObj.class);
        }
        if (configObj == null) {
            AsyncParticlesConfig.reset();
            return;
        }
        configObj = AsyncParticlesConfig.upgrade(configObj.version, configObj);
        configObj.flat();
        AsyncParticlesConfig.save(configObj);
    }

    @Contract
    private static ConfigObj upgrade(int ver, ConfigObj configObj) {
        return switch (ver) {
            case 1 -> configObj;
            default -> new ConfigObj();
        };
    }

    public static void save() throws IOException, JsonParseException {
        ConfigObj configObj = new ConfigObj();
        configObj.fold();
        AsyncParticlesConfig.save(configObj);
    }

    public static void reset() throws IOException {
        ConfigObj configObj = new ConfigObj();
        configObj.flat();
        AsyncParticlesConfig.save(configObj);
    }

    private static void save(ConfigObj configObj) throws IOException {
        configObj.version = 1;
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_FILE, new OpenOption[0]);){
            GSON.toJson((Object)configObj, (Appendable)writer);
        }
    }

    static class ConfigObj {
        int version = 0;
        Particle particle = new Particle();
        Tick tick = new Tick();
        Rendering rendering = new Rendering();
        ValkyrienSkies valkyrienSkies = new ValkyrienSkies();
        Create create = new Create();

        ConfigObj() {
        }

        private void flat() {
            this.particle.flat();
            this.tick.flat();
            this.rendering.flat();
            this.valkyrienSkies.flat();
            this.create.flat();
        }

        private void fold() {
            this.particle.fold();
            this.tick.fold();
            this.rendering.fold();
            this.valkyrienSkies.fold();
            this.create.fold();
        }

        static class Particle {
            int particleLimit = 16384;
            boolean removeIfMissedTick = false;
            boolean particleLightCache = true;
            boolean cullUnderwaterParticleType = true;

            Particle() {
            }

            private void flat() {
                particle$particleLimit = class_3532.method_15340((int)this.particleLimit, (int)1024, (int)262144);
                particle$removeIfMissedTick = this.removeIfMissedTick;
                particle$particleLightCache = this.particleLightCache;
                particle$cullUnderwaterParticleType = this.cullUnderwaterParticleType;
            }

            private void fold() {
                this.particleLimit = particle$particleLimit;
                this.removeIfMissedTick = particle$removeIfMissedTick;
                this.particleLightCache = particle$particleLightCache;
                this.cullUnderwaterParticleType = particle$cullUnderwaterParticleType;
            }
        }

        static class Tick {
            TickMode animationTickMode = TickMode.INTERRUPTIBLE;
            TickMode particleTickMode = TickMode.INTERRUPTIBLE;
            int failPerSecLimit = 5;
            FailBehavior failBehavior = FailBehavior.RAISE_CRASH;
            boolean suppressCME = false;

            Tick() {
            }

            private void flat() {
                tick$animationTickMode = Objects.requireNonNullElse(this.animationTickMode, TickMode.INTERRUPTIBLE);
                tick$particleTickMode = Objects.requireNonNullElse(this.particleTickMode, TickMode.INTERRUPTIBLE);
                tick$failPerSecLimit = class_3532.method_15340((int)this.failPerSecLimit, (int)0, (int)256);
                tick$failBehavior = Objects.requireNonNullElse(this.failBehavior, FailBehavior.RAISE_CRASH);
                tick$suppressCME = this.suppressCME;
            }

            private void fold() {
                this.animationTickMode = tick$animationTickMode;
                this.particleTickMode = tick$particleTickMode;
                this.failPerSecLimit = tick$failPerSecLimit;
                this.failBehavior = tick$failBehavior;
                this.suppressCME = tick$suppressCME;
            }
        }

        static class Rendering {
            boolean cullParticles = true;
            RenderingMode particleRenderingMode = RenderingMode.DELAYED;
            int failPerSecLimit = 20;
            FailBehavior failBehavior = FailBehavior.MARK_AS_SYNC;

            Rendering() {
            }

            private void flat() {
                rendering$cullParticles = this.cullParticles;
                rendering$particleRenderingMode = Objects.requireNonNullElse(this.particleRenderingMode, RenderingMode.DELAYED);
                rendering$failPerSecLimit = class_3532.method_15340((int)this.failPerSecLimit, (int)0, (int)256);
                rendering$failBehavior = Objects.requireNonNullElse(this.failBehavior, FailBehavior.MARK_AS_SYNC);
            }

            private void fold() {
                this.cullParticles = rendering$cullParticles;
                this.particleRenderingMode = rendering$particleRenderingMode;
                this.failPerSecLimit = rendering$failPerSecLimit;
                this.failBehavior = rendering$failBehavior;
            }
        }

        static class ValkyrienSkies {
            RainEffect rainEffect = RainEffect.STATIONARY;
            boolean fixParticleLights = true;

            ValkyrienSkies() {
            }

            private void flat() {
                valkyrienSkies$rainEffect = Objects.requireNonNullElse(this.rainEffect, RainEffect.STATIONARY);
                valkyrienSkies$fixParticleLights = this.fixParticleLights;
            }

            private void fold() {
                this.rainEffect = valkyrienSkies$rainEffect;
                this.fixParticleLights = valkyrienSkies$fixParticleLights;
            }
        }

        static class Create {
            RainEffect rainEffect = RainEffect.ALWAYS;

            Create() {
            }

            private void flat() {
                create$rainEffect = Objects.requireNonNullElse(this.rainEffect, RainEffect.ALWAYS);
            }

            private void fold() {
                this.rainEffect = create$rainEffect;
            }
        }
    }
}

