/*
 * Decompiled with CFR 0.152.
 */
package fabric.fun.qu_an.minecraft.asyncparticles.client.mixin.tick;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.systems.RenderSystem;
import fabric.fun.qu_an.minecraft.asyncparticles.client.AsyncTicker;
import fabric.fun.qu_an.minecraft.asyncparticles.client.addon.LightCachedParticleAddon;
import fabric.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleAddon;
import fabric.fun.qu_an.minecraft.asyncparticles.client.config.ConfigHelper;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.BusyWaitEvictingQueue;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionUtil;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.IterationSafeEvictingQueue;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.Utils;
import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import net.minecraft.class_3695;
import net.minecraft.class_3999;
import net.minecraft.class_5878;
import net.minecraft.class_638;
import net.minecraft.class_702;
import net.minecraft.class_703;
import net.minecraft.class_733;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_702.class}, priority=500)
public abstract class MixinParticleEngine {
    @Shadow
    public Queue<class_703> field_3836;
    @Shadow
    public Map<class_3999, Queue<class_703>> field_3830;
    @Shadow
    protected class_638 field_3834;
    @Mutable
    @Shadow
    public Queue<class_733> field_3837;

    @Shadow
    public abstract void method_3059(class_703 var1);

    @Shadow
    public abstract void method_34022(class_5878 var1, int var2);

    @Inject(method={"tickParticle"}, at={@At(value="INVOKE", target="Lnet/minecraft/CrashReport;forThrowable(Ljava/lang/Throwable;Ljava/lang/String;)Lnet/minecraft/CrashReport;")})
    public void onTickParticle(class_703 particle, CallbackInfo ci, @Local Throwable t) {
        if (ConfigHelper.isTickAsync()) {
            throw ExceptionUtil.toThrowDirectly(t);
        }
    }

    @Overwrite
    public void method_3057() {
        this.field_3830.forEach((particleRenderType, queue) -> {
            class_3695 profiler = this.field_3834.method_16107();
            profiler.method_15396(particleRenderType.toString());
            AsyncTicker.PARTICLE_OPERATIONS.add(() -> this.method_3048((Collection<class_703>)queue));
            profiler.method_15407();
        });
        AsyncTicker.PARTICLE_OPERATIONS.add(this::asyncparticles$tickEmitters);
        boolean tickAsync = ConfigHelper.isTickAsync();
        if (tickAsync) {
            AsyncTicker.waitForCleanUp();
        } else {
            AsyncTicker.PARTICLE_OPERATIONS.forEach(Runnable::run);
            AsyncTicker.PARTICLE_OPERATIONS.clear();
            AsyncTicker.tickSyncParticles();
            this.field_3830.values().forEach(q -> q.removeIf(p -> {
                if (p.method_3086()) {
                    return false;
                }
                p.method_34019().ifPresent(group -> this.method_34022((class_5878)group, -1));
                return true;
            }));
        }
        if (!this.field_3836.isEmpty()) {
            for (class_703 particle : this.field_3836) {
                if (tickAsync && ((ParticleAddon)particle).asyncparticles$isTickSync()) {
                    AsyncTicker.recordSync(particle);
                }
                Queue queue2 = this.field_3830.computeIfAbsent(particle.method_18122(), k -> {
                    IterationSafeEvictingQueue<class_703> queue1 = IterationSafeEvictingQueue.newInstance(16, ConfigHelper.getParticleLimit(), AsyncTicker::onEvicted);
                    if (tickAsync) {
                        AsyncTicker.PARTICLE_OPERATIONS.add(() -> this.method_3048(queue1));
                    }
                    return queue1;
                });
                queue2.add(particle);
            }
            this.field_3836.clear();
        }
    }

    @Unique
    private void asyncparticles$tickEmitters() {
        for (class_733 emitter : this.field_3837) {
            if (AsyncTicker.isCancelled() && !ConfigHelper.forceDoneParticleTick()) {
                return;
            }
            if (!emitter.method_3086()) continue;
            if (!RenderSystem.isOnRenderThread() && ((ParticleAddon)emitter).asyncparticles$isTickSync()) {
                AsyncTicker.recordSync((class_703)emitter);
                continue;
            }
            try {
                emitter.method_3070();
            }
            catch (Throwable t) {
                AsyncTicker.onTickingParticleException((class_703)emitter, t);
            }
        }
    }

    @Overwrite
    private void method_3048(Collection<class_703> collection) {
        if (collection.isEmpty()) {
            return;
        }
        boolean enableLightCache = ConfigHelper.particleLightCache();
        for (class_703 particle : collection) {
            if (AsyncTicker.isCancelled() && !ConfigHelper.forceDoneParticleTick()) {
                return;
            }
            if (!particle.method_3086()) {
                Utils.DUMMY_ITERATOR.remove();
                continue;
            }
            if (!RenderSystem.isOnRenderThread()) {
                if (((ParticleAddon)particle).asyncparticles$isTicked()) {
                    if (!enableLightCache) continue;
                    ((LightCachedParticleAddon)particle).asyncparticles$refresh();
                    continue;
                }
                if (((ParticleAddon)particle).asyncparticles$isTickSync()) {
                    AsyncTicker.recordSync(particle);
                    continue;
                }
            }
            try {
                this.method_3059(particle);
                if (enableLightCache) {
                    ((LightCachedParticleAddon)particle).asyncparticles$refresh();
                }
                ((ParticleAddon)particle).asyncparticles$setTicked();
            }
            catch (Throwable t) {
                AsyncTicker.onTickingParticleException(particle, t);
            }
        }
    }

    @Inject(method={"add"}, at={@At(value="HEAD")})
    public void add(class_703 particle, CallbackInfo ci) {
        if (!AsyncTicker.shouldTickParticles && ConfigHelper.isTickAsync()) {
            particle.method_3085();
        } else if (ConfigHelper.particleLightCache()) {
            ((LightCachedParticleAddon)particle).asyncparticles$refresh();
        }
    }

    @Inject(method={"clearParticles"}, at={@At(value="HEAD")})
    public void redirectClearParticles(CallbackInfo ci) {
        this.field_3836.forEach(AsyncTicker::onEvicted);
        this.field_3836 = BusyWaitEvictingQueue.newInstance(1024, ConfigHelper.getParticleLimit(), AsyncTicker::onEvicted);
        this.field_3837.forEach(AsyncTicker::onEvicted);
        this.field_3837 = BusyWaitEvictingQueue.newInstance(256, ConfigHelper.getParticleLimit(), AsyncTicker::onEvicted);
        this.field_3830.values().forEach(queue -> queue.forEach(AsyncTicker::onEvicted));
        AsyncTicker.onParticleEngineClear();
    }
}

