/*
 * Decompiled with CFR 0.152.
 */
package forge.fun.qu_an.minecraft.asyncparticles.client.coremod.mixin_extension.target_modifier;

import com.bawnorton.mixinsquared.canceller.MixinCancellerRegistrar;
import com.bawnorton.mixinsquared.reflection.FieldReference;
import forge.fun.qu_an.minecraft.asyncparticles.client.coremod.mixin_extension.target_modifier.ClassRenamer;
import forge.fun.qu_an.minecraft.asyncparticles.client.coremod.mixin_extension.target_modifier.MixinClassAdjuster;
import forge.fun.qu_an.minecraft.asyncparticles.client.coremod.mixin_extension.target_modifier.MixinClassAdjusterRegistrar;
import forge.fun.qu_an.minecraft.asyncparticles.client.coremod.mixin_extension.target_modifier.MixinClassProvider;
import forge.fun.qu_an.minecraft.asyncparticles.client.coremod.mixin_extension.target_modifier.MixinServiceWrapper;
import forge.fun.qu_an.minecraft.asyncparticles.client.coremod.mixin_extension.target_modifier.MixinTransformerExtension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.logging.ILogger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.extensibility.IMixinConfig;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.refmap.IReferenceMapper;
import org.spongepowered.asm.mixin.refmap.ReferenceMapper;
import org.spongepowered.asm.mixin.refmap.RemappingReferenceMapper;
import org.spongepowered.asm.mixin.throwables.MixinError;
import org.spongepowered.asm.mixin.transformer.IMixinTransformer;
import org.spongepowered.asm.mixin.transformer.ext.Extensions;
import org.spongepowered.asm.service.IClassBytecodeProvider;
import org.spongepowered.asm.service.IMixinService;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.util.Annotations;

public class MixinClassAdjusterApplication {
    static final ILogger LOGGER = MixinService.getService().getLogger("mixinsquared-class-adjuster");
    private static MixinClassAdjusterApplication INSTANCE;
    private static final FieldReference<String> pluginClassName;
    private static final FieldReference<IMixinService> mixinService;
    private Map<String, MixinClassAdjuster> adjusters;
    private final Map<String, byte[]> runtimeMixins = new HashMap<String, byte[]>();
    private final Map<String, String> generatedToOriginalMixins = new HashMap<String, String>();
    private final Set<String> originalMixins = new HashSet<String>();
    private final IMixinConfigPlugin mixinSquaredPlugin;
    private final String generatedMixinPrefix;

    public static void init(String packageName, IMixinConfigPlugin mixinSquaredPlugin) {
        if (INSTANCE != null) {
            throw new IllegalStateException("MixinClassAdjusterApplication is already initialized");
        }
        INSTANCE = new MixinClassAdjusterApplication(packageName, mixinSquaredPlugin);
    }

    public static MixinClassAdjusterApplication getInstance() {
        return INSTANCE;
    }

    private MixinClassAdjusterApplication(String packagename, IMixinConfigPlugin mixinSquaredPlugin) {
        MixinCancellerRegistrar.register((targetClassName, mixinClassName) -> this.originalMixins.contains(mixinClassName));
        this.mixinSquaredPlugin = mixinSquaredPlugin;
        this.generatedMixinPrefix = packagename + ".MixinSquaredGenerated$";
    }

    public String getGeneratedMixinPrefix(String mixinClassName) {
        return this.generatedMixinPrefix + mixinClassName.replace("/", "$_").replace(".", "$_");
    }

    public boolean shouldApplyMixin(String targetClassName, String generatedMixinClassName) {
        String mixinClassName = this.generatedToOriginalMixins.get(generatedMixinClassName);
        if (mixinClassName == null) {
            return true;
        }
        return this.adjusters.get(mixinClassName).shouldApplyMixin(targetClassName);
    }

    public List<String> apply() {
        MixinServiceWrapper mixinServiceWrapper;
        IMixinTransformer activeTransformer = (IMixinTransformer)MixinEnvironment.getDefaultEnvironment().getActiveTransformer();
        List pendingConfigs = MixinTransformerExtension.tryAs(activeTransformer).map(MixinTransformerExtension::getPendingConfigs).orElseThrow(() -> new UnsupportedOperationException("Unsupported mixin transformer: " + String.valueOf(activeTransformer.getClass())));
        IMixinConfig mixinConfig = null;
        String pluginClass = this.mixinSquaredPlugin.getClass().getName();
        for (IMixinConfig config : pendingConfigs) {
            String aPlugin = (String)pluginClassName.get((Object)config);
            if (!pluginClass.equals(aPlugin)) continue;
            mixinConfig = config;
            break;
        }
        assert (mixinConfig != null);
        IMixinService service = (IMixinService)mixinService.get(mixinConfig);
        if (!(service instanceof MixinServiceWrapper)) {
            LOGGER.info("Wrapping mixin service for {} so that we can modify target classes.", new Object[]{mixinConfig});
            mixinServiceWrapper = new MixinServiceWrapper(service);
            mixinService.set((Object)mixinConfig, (Object)mixinServiceWrapper);
        } else {
            mixinServiceWrapper = (MixinServiceWrapper)service;
        }
        HashMap<String, IReferenceMapper> mappersCache = new HashMap<String, IReferenceMapper>();
        this.adjusters = MixinClassAdjusterRegistrar.endAdjusters();
        for (MixinClassAdjuster adjuster : this.adjusters.values()) {
            this.applyAdjuster(mixinServiceWrapper, adjuster, mappersCache);
        }
        Set<MixinClassProvider> providers = MixinClassAdjusterRegistrar.endProviders();
        ArrayList<String> mixins = new ArrayList<String>(this.generatedToOriginalMixins.size() + providers.size());
        for (String s : this.generatedToOriginalMixins.keySet()) {
            String substring = s.substring(s.lastIndexOf(46) + 1);
            mixins.add(substring);
        }
        for (MixinClassProvider provider : providers) {
            ClassNode mixinClass = provider.getMixinClass();
            ClassRenamer.renameClass(mixinClass, this.getGeneratedMixinPrefix(mixinClass.name));
            this.genClass(mixinClass);
            mixins.add(mixinClass.name.substring(mixinClass.name.lastIndexOf(47) + 1));
        }
        return mixins;
    }

    private void applyAdjuster(IClassBytecodeProvider bytecodeProvider, MixinClassAdjuster adjuster, Map<String, IReferenceMapper> mappersCache) {
        ArrayList<Object> finalTargets;
        List<String> unmodifiableTargets;
        List<String> modifiedTargets;
        boolean isModifiedTargets;
        ClassNode cNode;
        String mixinClassName = adjuster.getMixinClassName();
        try {
            cNode = bytecodeProvider.getClassNode(mixinClassName);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new MixinError((Throwable)e);
        }
        ArrayList<String> targets = new ArrayList<String>();
        AnnotationNode aNode = Annotations.getInvisible((ClassNode)cNode, Mixin.class);
        List values = aNode.values;
        int targetIndex = -1;
        int priorityIndex = -1;
        ListIterator iterator = values.listIterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Object value = iterator.next();
            if ("value".equals(key)) {
                List classes = (List)value;
                if (classes.isEmpty()) continue;
                for (Type c : classes) {
                    targets.add(c.getClassName());
                }
                iterator.set(Collections.emptyList());
                continue;
            }
            if ("targets".equals(key)) {
                List originalTargets = (List)value;
                if (originalTargets.isEmpty()) continue;
                targets.addAll(originalTargets);
                targetIndex = iterator.previousIndex();
                iterator.set(Collections.emptyList());
                continue;
            }
            if (!"priority".equals(key)) continue;
            priorityIndex = iterator.previousIndex();
        }
        boolean modified = false;
        int originalPriority = priorityIndex > -1 ? (Integer)values.get(priorityIndex) : 1000;
        int priority = adjuster.getPriority(originalPriority);
        if (priority != originalPriority) {
            if (priorityIndex > -1) {
                values.set(priorityIndex, priority);
            } else {
                values.add("priority");
                values.add(priority);
            }
            modified = true;
        }
        boolean bl = isModifiedTargets = (modifiedTargets = adjuster.getTargets(unmodifiableTargets = Collections.unmodifiableList(targets))) != null && modifiedTargets != unmodifiableTargets;
        if (isModifiedTargets) {
            finalTargets = new ArrayList<String>(modifiedTargets);
            modified = true;
        } else {
            finalTargets = targets;
        }
        if (modified) {
            if (targetIndex > -1) {
                values.set(targetIndex, finalTargets);
            } else {
                values.add("targets");
                targetIndex = values.size();
                values.add(finalTargets);
            }
            String internalClassName = cNode.name;
            Object refMapperConfig = adjuster.getRefMapperConfig();
            if (refMapperConfig == null) {
                refMapperConfig = "mixin.refmap.json";
            }
            for (MethodNode methodNode : cNode.methods) {
                if (methodNode.visibleAnnotations == null) continue;
                for (AnnotationNode aNode1 : methodNode.visibleAnnotations) {
                    List l;
                    Object o;
                    int i = aNode1.values.indexOf("method");
                    if (i == -1 || !((o = aNode1.values.get(i + 1)) instanceof List) || (l = (List)o).isEmpty() || !(l.get(0) instanceof String)) continue;
                    List methods = l;
                    IReferenceMapper mapper = mappersCache.computeIfAbsent((String)refMapperConfig, k -> RemappingReferenceMapper.of((MixinEnvironment)MixinEnvironment.getDefaultEnvironment(), (IReferenceMapper)ReferenceMapper.read((String)k)));
                    ListIterator<String> iterator2 = methods.listIterator();
                    while (iterator2.hasNext()) {
                        String s1 = (String)iterator2.next();
                        if ((s1 = mapper.remap(internalClassName, s1)).indexOf(40) > s1.indexOf(59)) {
                            s1 = s1.substring(s1.indexOf(59) + 1);
                        }
                        iterator2.set(s1);
                    }
                }
            }
        }
        HashMap<String, ClassNode> specialTargets = null;
        if (isModifiedTargets) {
            for (String string : finalTargets) {
                ClassNode classNode = adjuster.adjustMixin(string, () -> {
                    ClassNode modifiedClassNode = new ClassNode();
                    cNode.accept((ClassVisitor)modifiedClassNode);
                    return modifiedClassNode;
                });
                if (classNode == null) continue;
                if (specialTargets == null) {
                    specialTargets = new HashMap<String, ClassNode>();
                }
                specialTargets.put(string, classNode);
            }
            if (specialTargets != null) {
                finalTargets.removeAll(specialTargets.keySet());
            }
        }
        if (modified) {
            String generatedMixin = this.getGeneratedMixinPrefix(mixinClassName);
            ClassRenamer.renameClass(cNode, generatedMixin);
            this.genClass(cNode);
            this.generatedToOriginalMixins.put(generatedMixin, mixinClassName);
            this.originalMixins.add(mixinClassName);
            if (specialTargets != null) {
                for (Map.Entry entry : specialTargets.entrySet()) {
                    String target = (String)entry.getKey();
                    ClassNode modifiedMixin = (ClassNode)entry.getValue();
                    ArrayList<String> targets1 = new ArrayList<String>(1);
                    targets1.add(target);
                    List values1 = Annotations.getInvisible((ClassNode)modifiedMixin, Mixin.class).values;
                    values1.set(targetIndex, targets1);
                    String generatedTarget = generatedMixin + "$TARGET_" + target.replace(".", "$_");
                    ClassRenamer.renameClass(modifiedMixin, generatedTarget);
                    this.genClass(modifiedMixin);
                    this.generatedToOriginalMixins.put(generatedTarget, mixinClassName);
                }
            }
        }
    }

    private void genClass(ClassNode node) {
        ClassWriter writer = new ClassWriter(2);
        node.accept((ClassVisitor)writer);
        byte[] bytes = writer.toByteArray();
        this.runtimeMixins.put(node.name, bytes);
        IMixinTransformer transformer = (IMixinTransformer)MixinEnvironment.getDefaultEnvironment().getActiveTransformer();
        ((Extensions)transformer.getExtensions()).export(MixinEnvironment.getCurrentEnvironment(), node.name, false, node);
    }

    byte[] getByteCode(String name) {
        return this.runtimeMixins.get(name.replace('.', '/'));
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        String originalMixinClassMame = this.generatedToOriginalMixins.get(mixinClassName);
        if (originalMixinClassMame == null) {
            return;
        }
        MixinClassAdjuster adjuster = this.adjusters.get(originalMixinClassMame);
        if (adjuster == null) {
            return;
        }
        adjuster.preApply(targetClassName, targetClass, originalMixinClassMame, mixinInfo);
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        String originalMixinClassMame = this.generatedToOriginalMixins.get(mixinClassName);
        if (originalMixinClassMame == null) {
            return;
        }
        MixinClassAdjuster adjuster = this.adjusters.get(originalMixinClassMame);
        if (adjuster == null) {
            return;
        }
        adjuster.postApply(targetClassName, targetClass, originalMixinClassMame, mixinInfo);
    }

    static {
        try {
            Class<?> mixinConfigClass = Class.forName("org.spongepowered.asm.mixin.transformer.MixinConfig");
            pluginClassName = new FieldReference(mixinConfigClass, "pluginClassName");
            mixinService = new FieldReference(mixinConfigClass, "service");
        }
        catch (ClassNotFoundException e) {
            throw new MixinError((Throwable)e);
        }
    }
}

