/*
 * Decompiled with CFR 0.152.
 */
package forge.fun.qu_an.minecraft.asyncparticles.client.mixin.fabric;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import forge.fun.qu_an.minecraft.asyncparticles.client.AsyncRenderer;
import forge.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleAddon;
import forge.fun.qu_an.minecraft.asyncparticles.client.config.ConfigHelper;
import forge.fun.qu_an.minecraft.asyncparticles.client.util.CustomTesselator;
import forge.fun.qu_an.minecraft.asyncparticles.client.util.FakeBufferBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ParticleEngine.class}, priority=500)
public abstract class MixinParticleEngine_Render {
    @Shadow
    public Map<ParticleRenderType, Queue<Particle>> f_107289_;
    @Shadow
    @Final
    public TextureManager f_107291_;
    @Shadow
    @Mutable
    public static List<ParticleRenderType> f_107288_;

    @Overwrite
    public void m_107336_(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, LightTexture lightTexture, Camera camera, float f) {
        ProfilerFiller profiler = Minecraft.m_91087_().m_91307_();
        boolean renderAsync = AsyncRenderer.isRenderAsync();
        if (renderAsync) {
            profiler.m_6180_("wait_for_async_tasks");
            AsyncRenderer.tryWaitForAsyncTasks();
            profiler.m_7238_();
        }
        profiler.m_6180_("prepare");
        Frustum frustum = AsyncRenderer.frustum;
        lightTexture.m_109896_();
        RenderSystem.enableDepthTest();
        PoseStack poseStack2 = RenderSystem.getModelViewStack();
        poseStack2.m_85836_();
        poseStack2.m_252931_(poseStack.m_85850_().m_252922_());
        RenderSystem.applyModelViewMatrix();
        profiler.m_7238_();
        boolean cullParticles = ConfigHelper.isCullParticles();
        boolean mixedParticleRendering = AsyncRenderer.isMixedParticleRendering();
        for (ParticleRenderType particleRenderType : f_107288_) {
            BufferBuilder toBegin;
            BufferBuilder bufferBuilder;
            Tesselator tesselator;
            Collection<Object> syncParticles;
            boolean enableCull;
            Queue<Particle> queue = this.f_107289_.get(particleRenderType);
            if (queue == null || queue.isEmpty()) continue;
            profiler.m_6180_("render_sync");
            if (!renderAsync) {
                enableCull = cullParticles;
                syncParticles = queue;
                tesselator = Tesselator.m_85913_();
                toBegin = bufferBuilder = tesselator.m_85915_();
            } else {
                bufferBuilder = AsyncRenderer.beginBufferBuilder(particleRenderType, this.f_107291_);
                if (bufferBuilder == FakeBufferBuilder.INSTANCE) {
                    enableCull = cullParticles;
                    syncParticles = mixedParticleRendering ? Collections.emptyList() : queue;
                    tesselator = Tesselator.m_85913_();
                    toBegin = bufferBuilder = tesselator.m_85915_();
                } else {
                    enableCull = false;
                    syncParticles = AsyncRenderer.getSync(particleRenderType);
                    tesselator = null;
                    toBegin = FakeBufferBuilder.INSTANCE;
                }
            }
            RenderSystem.setShader(GameRenderer::m_172829_);
            particleRenderType.m_6505_(toBegin, this.f_107291_);
            if (!syncParticles.isEmpty()) {
                float f2 = f + 1.0f;
                for (Particle particle : syncParticles) {
                    if (!particle.m_107276_() || enableCull && ((ParticleAddon)particle).shouldCull() && !frustum.m_113029_(particle.m_107277_())) continue;
                    float f3 = ((ParticleAddon)particle).asyncparticles$isTicked() ? f : f2;
                    try {
                        particle.m_5744_((VertexConsumer)bufferBuilder, camera, f3);
                    }
                    catch (Throwable t) {
                        throw AsyncRenderer.constructCrashReport(particle, particleRenderType, t);
                    }
                }
            }
            profiler.m_6182_("upload_particles");
            particleRenderType.m_6294_((Tesselator)(tesselator != null ? tesselator : CustomTesselator.of(bufferBuilder, b -> BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)b.m_231175_()))));
            if (bufferBuilder.m_85732_()) {
                bufferBuilder.m_231175_().m_231200_();
            }
            profiler.m_7238_();
        }
        profiler.m_6180_("cleanup");
        poseStack2.m_85849_();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableCull();
        RenderSystem.enableDepthTest();
        lightTexture.m_109891_();
        profiler.m_7238_();
    }
}

