/*
 * Decompiled with CFR 0.152.
 */
package forge.fun.qu_an.minecraft.asyncparticles.client.util;

import forge.fun.qu_an.minecraft.asyncparticles.client.util.IterationSafeEvictingQueue;
import forge.fun.qu_an.minecraft.asyncparticles.client.util.ReentrantSpinLock;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class BusyWaitEvictingQueue<E>
extends IterationSafeEvictingQueue<E> {
    private final ReentrantSpinLock lock = new ReentrantSpinLock();

    public BusyWaitEvictingQueue(int initialCapacity, int maxCapacity) {
        super(initialCapacity, maxCapacity);
    }

    public BusyWaitEvictingQueue(int initialCapacity, int maxCapacity, Consumer<E> onEvict) {
        super(initialCapacity, maxCapacity, onEvict);
    }

    public static <E> BusyWaitEvictingQueue<E> newInstance(int initialCapacity, int maxCapacity) {
        return new BusyWaitEvictingQueue<E>(Math.min(initialCapacity, maxCapacity), maxCapacity);
    }

    public static <E> BusyWaitEvictingQueue<E> newInstance(int initialCapacity, int maxCapacity, Consumer<E> onEvict) {
        return new BusyWaitEvictingQueue<E>(Math.min(initialCapacity, maxCapacity), maxCapacity, onEvict);
    }

    @Override
    public boolean add(E e) {
        return this.lock.wrap(() -> super.add(e));
    }

    @Override
    public boolean remove(Object o) {
        return this.lock.wrap(() -> super.remove(o));
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> c) {
        return this.lock.wrap(() -> super.addAll(c));
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        return this.lock.wrap(() -> super.removeAll(c));
    }

    @Override
    public boolean removeIf(@NotNull Predicate<? super E> filter) {
        return this.lock.wrap(() -> super.removeIf(filter));
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        return this.lock.wrap(() -> super.retainAll(c));
    }

    @Override
    public void clear() {
        this.lock.wrap(() -> super.clear());
    }

    @Override
    public boolean offer(E e) {
        return this.lock.wrap(() -> super.offer(e));
    }

    @Override
    public E remove() {
        return (E)this.lock.wrap(() -> super.remove());
    }

    @Override
    public E poll() {
        return (E)this.lock.wrap(() -> super.poll());
    }
}

