/*
 * Decompiled with CFR 0.152.
 */
package fabric.fun.qu_an.minecraft.asyncparticles.client.coremod.mixin_extension.target_modifier;

import com.bawnorton.mixinsquared.canceller.MixinCancellerRegistrar;
import com.bawnorton.mixinsquared.reflection.FieldReference;
import com.llamalad7.mixinextras.utils.ClassGenUtils;
import fabric.fun.qu_an.minecraft.asyncparticles.client.coremod.mixin_extension.target_modifier.ClassRenamer;
import fabric.fun.qu_an.minecraft.asyncparticles.client.coremod.mixin_extension.target_modifier.MixinServiceWrapper;
import fabric.fun.qu_an.minecraft.asyncparticles.client.coremod.mixin_extension.target_modifier.MixinTargetModifier;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.logging.ILogger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.extensibility.IMixinConfig;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.transformer.IMixinTransformer;
import org.spongepowered.asm.service.IClassBytecodeProvider;
import org.spongepowered.asm.service.IMixinService;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.util.Annotations;

public class MixinTargetsModifierApplication {
    static final ILogger LOGGER = MixinService.getService().getLogger("mixinsquared-target-modifier");
    static MixinTargetsModifierApplication INSTANCE;
    private static final FieldReference<String> pluginClassName;
    private static final FieldReference<IMixinService> mixinService;
    private static final FieldReference<List<IMixinConfig>> pendingConfigs;
    private static final FieldReference<?> mixinProcessor;
    static final Map<String, MixinTargetModifier> MODIFIERS;
    final Map<String, String> generatedToOriginalMixins = new HashMap<String, String>();
    final Set<String> originalMixins = new HashSet<String>();
    final MethodHandles.Lookup lookup;
    final IMixinConfigPlugin mixinSquaredPlugin;
    private final String generatedMixinPrefix;

    public static void init(MethodHandles.Lookup lookup, IMixinConfigPlugin mixinSquaredPlugin) {
        if (INSTANCE != null) {
            throw new IllegalStateException("TargetModifierApplication is already initialized");
        }
        INSTANCE = new MixinTargetsModifierApplication(lookup, mixinSquaredPlugin);
    }

    public static MixinTargetsModifierApplication getInstance() {
        return INSTANCE;
    }

    private MixinTargetsModifierApplication(MethodHandles.Lookup lookup, IMixinConfigPlugin mixinSquaredPlugin) {
        MixinCancellerRegistrar.register((targetClassName, mixinClassName) -> this.originalMixins.contains(mixinClassName));
        this.lookup = lookup;
        this.mixinSquaredPlugin = mixinSquaredPlugin;
        this.generatedMixinPrefix = lookup.lookupClass().getPackage().getName() + ".MixinSquaredGenerated$";
    }

    public List<String> applyModifiers() {
        MixinServiceWrapper mixinServiceWrapper;
        IMixinConfig config;
        String aPlugin;
        IMixinTransformer activeTransformer = (IMixinTransformer)MixinEnvironment.getDefaultEnvironment().getActiveTransformer();
        List pendingConfigs = (List)MixinTargetsModifierApplication.pendingConfigs.get(mixinProcessor.get((Object)activeTransformer));
        IMixinConfig mixinConfig = null;
        String pluginClass = this.mixinSquaredPlugin.getClass().getName();
        Iterator iterator = pendingConfigs.iterator();
        while (iterator.hasNext() && !pluginClass.equals(aPlugin = (String)pluginClassName.get((Object)(mixinConfig = (config = (IMixinConfig)iterator.next()))))) {
        }
        assert (pluginClass.equals(pluginClassName.get((Object)mixinConfig)));
        IMixinService service = (IMixinService)mixinService.get(mixinConfig);
        if (!(service instanceof MixinServiceWrapper)) {
            LOGGER.info("Wrapping mixin service for {} so that we can modify target classes.", new Object[]{mixinConfig});
            mixinServiceWrapper = new MixinServiceWrapper(service);
            mixinService.set((Object)mixinConfig, (Object)mixinServiceWrapper);
        } else {
            mixinServiceWrapper = (MixinServiceWrapper)service;
        }
        IClassBytecodeProvider bytecodeProvider = mixinServiceWrapper.getBytecodeProvider();
        for (MixinTargetModifier modifier : MODIFIERS.values()) {
            this.applyModifier(bytecodeProvider, modifier);
        }
        ArrayList<String> list = new ArrayList<String>(this.generatedToOriginalMixins.size());
        for (String s : this.generatedToOriginalMixins.keySet()) {
            String substring = s.substring(s.lastIndexOf(46) + 1);
            list.add(substring);
        }
        return list;
    }

    public boolean shouldApplyMixin(String targetClassName, String generatedMixinClassName) {
        String mixinClassName = this.generatedToOriginalMixins.get(generatedMixinClassName);
        return MODIFIERS.get(mixinClassName).shouldApplyMixin(targetClassName);
    }

    private void applyModifier(IClassBytecodeProvider bytecodeProvider, MixinTargetModifier modifier) {
        ClassNode cNode;
        String mixinClassName = modifier.getMixinClassName();
        try {
            cNode = bytecodeProvider.getClassNode(mixinClassName);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        ArrayList<String> targets = new ArrayList<String>();
        AnnotationNode aNode = Annotations.getInvisible((ClassNode)cNode, Mixin.class);
        List values = aNode.values;
        int targetIndex = -1;
        ListIterator iterator = values.listIterator();
        while (iterator.hasNext()) {
            List originalTargets;
            String key = (String)iterator.next();
            Object value = iterator.next();
            if ("value".equals(key)) {
                List classes = (List)value;
                if (classes.isEmpty()) continue;
                for (Type c : classes) {
                    targets.add(c.getClassName());
                }
                iterator.set(Collections.emptyList());
                continue;
            }
            if (!"targets".equals(key) || (originalTargets = (List)value).isEmpty()) continue;
            targets.addAll(originalTargets);
            targetIndex = iterator.previousIndex();
        }
        List<String> unmodifiableList = Collections.unmodifiableList(targets);
        List<String> mixins = modifier.getTargets(unmodifiableList);
        if (mixins == null || mixins == unmodifiableList) {
            return;
        }
        if (targetIndex > -1) {
            values.set(targetIndex, new ArrayList<String>(mixins));
        } else {
            values.add("targets");
            values.add(new ArrayList<String>(mixins));
        }
        String generatedMixin = this.generatedMixinPrefix + mixinClassName.substring(mixinClassName.lastIndexOf(46) + 1);
        ClassRenamer.renameClass(cNode, generatedMixin);
        ClassGenUtils.defineClass((ClassNode)cNode, (MethodHandles.Lookup)this.lookup);
        this.generatedToOriginalMixins.put(generatedMixin, mixinClassName);
        this.originalMixins.add(mixinClassName);
    }

    static {
        try {
            Class<?> mixinConfigClass = Class.forName("org.spongepowered.asm.mixin.transformer.MixinConfig");
            pluginClassName = new FieldReference(mixinConfigClass, "pluginClassName");
            mixinService = new FieldReference(mixinConfigClass, "service");
            Class<?> mixinProcessorClass = Class.forName("org.spongepowered.asm.mixin.transformer.MixinProcessor");
            pendingConfigs = new FieldReference(mixinProcessorClass, "pendingConfigs");
            Class<?> mixinTransformerClass = Class.forName("org.spongepowered.asm.mixin.transformer.MixinTransformer");
            mixinProcessor = new FieldReference(mixinTransformerClass, "processor");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        MODIFIERS = new HashMap<String, MixinTargetModifier>();
    }
}

