/*
 * Decompiled with CFR 0.152.
 */
package fabric.fun.qu_an.minecraft.asyncparticles.client.mixin.tick;

import com.google.common.collect.ImmutableList;
import com.llamalad7.mixinextras.sugar.Local;
import fabric.fun.qu_an.minecraft.asyncparticles.client.AsyncTicker;
import fabric.fun.qu_an.minecraft.asyncparticles.client.addon.LightCachedParticleAddon;
import fabric.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleAddon;
import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.ModListHelper;
import fabric.fun.qu_an.minecraft.asyncparticles.client.config.SimplePropertiesConfig;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.BusyWaitEvictingQueue;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionUtil;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.IterationSafeEvictingQueue;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.TrackedParticleCountsMap;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.Utils;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_10209;
import net.minecraft.class_3695;
import net.minecraft.class_3999;
import net.minecraft.class_5819;
import net.minecraft.class_5878;
import net.minecraft.class_638;
import net.minecraft.class_6575;
import net.minecraft.class_702;
import net.minecraft.class_703;
import net.minecraft.class_733;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_702.class}, priority=500)
public abstract class MixinParticleEngine {
    @Mutable
    @Shadow
    public Queue<class_703> field_3836;
    @Shadow
    @Final
    public Map<class_3999, Queue<class_703>> field_3830;
    @Shadow
    protected class_638 field_3834;
    @Mutable
    @Shadow
    @Final
    public Queue<class_733> field_3837;
    @Mutable
    @Shadow
    @Final
    private Object2IntOpenHashMap<class_5878> field_29072;
    @Shadow
    @Mutable
    public static List<class_3999> field_17820;
    @Mutable
    @Shadow
    @Final
    private class_5819 field_3832;

    @Inject(method={"<init>"}, order=9000, at={@At(value="RETURN")})
    public void init(CallbackInfo ci) {
        this.field_29072 = new TrackedParticleCountsMap();
        this.field_3836 = new BusyWaitEvictingQueue<class_703>(1024, SimplePropertiesConfig.getLimit(), AsyncTicker::onEvicted);
        this.field_3837 = new BusyWaitEvictingQueue<class_733>(256, SimplePropertiesConfig.getLimit(), AsyncTicker::onEvicted);
        this.field_3832 = new class_6575((long)ThreadLocalRandom.current().nextInt());
    }

    @Shadow
    public abstract void method_34022(class_5878 var1, int var2);

    @Shadow
    public abstract void method_3059(class_703 var1);

    @Inject(method={"tickParticle"}, at={@At(value="INVOKE", target="Lnet/minecraft/CrashReport;forThrowable(Ljava/lang/Throwable;Ljava/lang/String;)Lnet/minecraft/CrashReport;")})
    public void onTickParticle(class_703 particle, CallbackInfo ci, @Local Throwable t) {
        if (SimplePropertiesConfig.isTickAsync()) {
            throw ExceptionUtil.toThrowDirectly(t);
        }
    }

    @Overwrite
    public void method_3057() {
        this.field_3830.forEach((particleRenderType, queue) -> {
            class_3695 profiler = class_10209.method_64146();
            profiler.method_15396(particleRenderType.toString());
            AsyncTicker.PARTICLE_OPERATIONS.add(() -> this.method_3048((Collection<class_703>)queue));
            profiler.method_15407();
        });
        AsyncTicker.PARTICLE_OPERATIONS.add(() -> {
            for (class_733 emitter : this.field_3837) {
                if (AsyncTicker.isCancelled() && !SimplePropertiesConfig.forceDoneParticleTick()) {
                    return;
                }
                if (!emitter.method_3086()) continue;
                if (((ParticleAddon)emitter).asyncparticles$isTickSync()) {
                    AsyncTicker.recordSync((class_703)emitter);
                    continue;
                }
                try {
                    emitter.method_3070();
                }
                catch (Throwable t) {
                    AsyncTicker.onTickingParticleException((class_703)emitter, t);
                }
            }
        });
        if (SimplePropertiesConfig.isTickAsync()) {
            AsyncTicker.waitForCleanUp();
        } else {
            AsyncTicker.PARTICLE_OPERATIONS.forEach(Runnable::run);
            AsyncTicker.PARTICLE_OPERATIONS.clear();
            AsyncTicker.tickSyncParticles();
            this.field_3830.values().forEach(q -> q.removeIf(p -> {
                if (p.method_3086()) {
                    return false;
                }
                p.method_34019().ifPresent(group -> this.method_34022((class_5878)group, -1));
                return true;
            }));
        }
        if (!this.field_3836.isEmpty()) {
            for (class_703 particle : this.field_3836) {
                if (((ParticleAddon)particle).asyncparticles$isTickSync()) {
                    AsyncTicker.recordSync(particle);
                }
                Queue queue2 = this.field_3830.computeIfAbsent(particle.method_18122(), k -> {
                    IterationSafeEvictingQueue<class_703> queue1 = new IterationSafeEvictingQueue<class_703>(16, SimplePropertiesConfig.getLimit(), AsyncTicker::onEvicted);
                    if (SimplePropertiesConfig.isTickAsync()) {
                        AsyncTicker.PARTICLE_OPERATIONS.add(() -> this.method_3048(queue1));
                    }
                    if (!ModListHelper.IS_FORGE && k.comp_3341() != null && !field_17820.contains(k)) {
                        field_17820 = ImmutableList.builder().addAll(field_17820).add(k).build();
                    }
                    return queue1;
                });
                queue2.add(particle);
            }
            this.field_3836.clear();
        }
    }

    @Overwrite
    private void method_3048(Collection<class_703> collection) {
        if (collection.isEmpty()) {
            return;
        }
        for (class_703 particle : collection) {
            LightCachedParticleAddon lightCachedParticle;
            if (AsyncTicker.isCancelled() && !SimplePropertiesConfig.forceDoneParticleTick()) {
                return;
            }
            if (!particle.method_3086()) {
                Utils.DUMMY_ITERATOR.remove();
                continue;
            }
            if (((ParticleAddon)particle).asyncparticles$isTicked()) {
                if (!(particle instanceof LightCachedParticleAddon)) continue;
                lightCachedParticle = (LightCachedParticleAddon)particle;
                if (!SimplePropertiesConfig.particleLightCache()) continue;
                lightCachedParticle.asyncparticles$refresh();
                continue;
            }
            if (((ParticleAddon)particle).asyncparticles$isTickSync()) {
                AsyncTicker.recordSync(particle);
                continue;
            }
            try {
                this.method_3059(particle);
                if (particle instanceof LightCachedParticleAddon) {
                    lightCachedParticle = (LightCachedParticleAddon)particle;
                    if (SimplePropertiesConfig.particleLightCache()) {
                        lightCachedParticle.asyncparticles$refresh();
                    }
                }
                ((ParticleAddon)particle).asyncparticles$setTicked();
            }
            catch (Throwable t) {
                AsyncTicker.onTickingParticleException(particle, t);
            }
        }
    }

    @Inject(method={"add"}, at={@At(value="HEAD")}, cancellable=true)
    public void add(class_703 particle, CallbackInfo ci) {
        if (!AsyncTicker.shouldTickParticles && SimplePropertiesConfig.isTickAsync()) {
            particle.method_3085();
        } else if (particle instanceof LightCachedParticleAddon) {
            LightCachedParticleAddon lightCachedParticle = (LightCachedParticleAddon)particle;
            if (SimplePropertiesConfig.particleLightCache()) {
                lightCachedParticle.asyncparticles$refresh();
            }
        }
    }

    @Inject(method={"clearParticles"}, at={@At(value="HEAD")})
    public void onClearParticles(CallbackInfo ci) {
        this.field_3836.forEach(AsyncTicker::onEvicted);
        this.field_3836 = new BusyWaitEvictingQueue<class_703>(1024, SimplePropertiesConfig.getLimit(), AsyncTicker::onEvicted);
        this.field_3837.forEach(AsyncTicker::onEvicted);
        this.field_3837 = new BusyWaitEvictingQueue<class_733>(256, SimplePropertiesConfig.getLimit(), AsyncTicker::onEvicted);
        this.field_3830.values().forEach(queue -> queue.forEach(AsyncTicker::onEvicted));
        AsyncTicker.onParticleEngineClear();
    }
}

