/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.AsyncRenderer;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.AsyncTicker;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleAddon;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Particle.class})
public abstract class MixinParticle
implements ParticleAddon {
    @Shadow
    public double x;
    @Shadow
    public double y;
    @Shadow
    public double z;
    @Shadow
    @Final
    public ClientLevel level;
    @Unique
    private boolean asyncparticles$ticked = true;
    @Unique
    private boolean asyncparticles$renderSync;
    @Unique
    private boolean asyncparticles$tickSync;

    @Shadow
    public abstract void remove();

    @Shadow
    public abstract boolean isAlive();

    @Inject(method={"<init>*"}, at={@At(value="RETURN")})
    private void onInit(CallbackInfo ci) {
        if (AsyncRenderer.shouldSync(((Particle)this).getClass())) {
            this.asyncparticles$setRenderSync();
        }
        if (AsyncTicker.shouldSync(((Particle)this).getClass())) {
            this.asyncparticles$setTickSync();
        }
    }

    @WrapOperation(method={"<init>(Lnet/minecraft/client/multiplayer/ClientLevel;DDD)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/RandomSource;create()Lnet/minecraft/util/RandomSource;")})
    private RandomSource onInit(Operation<RandomSource> original) {
        return new SingleThreadedRandomSource(RandomSupport.generateUniqueSeed());
    }

    @Override
    public boolean asyncparticles$shouldRemove() {
        if (!this.isAlive()) {
            return true;
        }
        if (this.asyncparticles$ticked) {
            this.asyncparticles$ticked = false;
            return false;
        }
        this.remove();
        return true;
    }

    @Override
    public void asyncparticles$setTicked() {
        this.asyncparticles$ticked = true;
    }

    @Override
    public boolean asyncparticles$isTicked() {
        return this.asyncparticles$ticked;
    }

    @Override
    public void asyncparticles$setRenderSync() {
        this.asyncparticles$renderSync = true;
    }

    @Override
    public boolean asyncparticles$isRenderSync() {
        return this.asyncparticles$renderSync;
    }

    @Override
    public void asyncparticles$setTickSync() {
        this.asyncparticles$tickSync = true;
    }

    @Override
    public boolean asyncparticles$isTickSync() {
        return this.asyncparticles$tickSync;
    }
}

