/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client.neoforge;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.AsyncRenderer;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.AsyncTicker;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.AsyncparticlesClient;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.compat.ModListHelper;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.config.SimplePropertiesConfig;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.moddiscovery.ModInfo;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.common.NeoForge;

@Mod(value="asyncparticles")
public final class AsyncparticlesClientNeoForge {
    public AsyncparticlesClientNeoForge(IEventBus modBus) {
        if (!ModListHelper.IS_CLIENT) {
            return;
        }
        AsyncparticlesClient.init();
        NeoForge.EVENT_BUS.addListener(this::registerClientCommands);
    }

    private static CompletableFuture<Suggestions> suggestModId(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.suggest(FMLLoader.getLoadingModList().getMods().stream().map(ModInfo::getModId), (SuggestionsBuilder)builder);
    }

    private void registerClientCommands(RegisterClientCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"asyncparticles").then(Commands.literal((String)"isfabricmod").then(Commands.argument((String)"modid", (ArgumentType)StringArgumentType.word()).suggests(AsyncparticlesClientNeoForge::suggestModId).executes(context -> {
            String modId = StringArgumentType.getString((CommandContext)context, (String)"modid");
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)(modId + " is " + (ModListHelper.isFabricModLoaded(modId) ? "fabric mod" : (ModListHelper.isModLoaded(modId) ? "not fabric mod" : "not loaded")))));
            return 1;
        })))).then(Commands.literal((String)"isforgemod").then(Commands.argument((String)"modid", (ArgumentType)StringArgumentType.word()).suggests(AsyncparticlesClientNeoForge::suggestModId).executes(context -> {
            String modId = StringArgumentType.getString((CommandContext)context, (String)"modid");
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)(modId + " is " + (ModListHelper.isForgeModLoaded(modId) ? "forge mod" : (ModListHelper.isModLoaded(modId) ? "not forge mod" : "not loaded")))));
            return 1;
        })))).then(Commands.literal((String)"debug").executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            AsyncTicker.debugLater(s -> source.sendSystemMessage((Component)Component.literal((String)s).withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, s)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Copy to clipboard"))))));
            AsyncRenderer.debugLater(s -> source.sendSystemMessage((Component)Component.literal((String)s).withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, s)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Copy to clipboard"))))));
            return 1;
        }))).then(Commands.literal((String)"dump").executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            AsyncTicker.dumpParticles();
            source.sendSystemMessage((Component)Component.literal((String)"Particles have been dumped to log."));
            return 1;
        }))).then(Commands.literal((String)"class_exists").then(Commands.argument((String)"className", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String className = StringArgumentType.getString((CommandContext)context, (String)"className");
            if (ModListHelper.classExists(className)) {
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("Class " + className + " found!")));
            } else {
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("Class " + className + " not found.")));
            }
            return 1;
        })))).then(Commands.literal((String)"version_check").then(((RequiredArgumentBuilder)Commands.argument((String)"modid", (ArgumentType)StringArgumentType.word()).suggests(AsyncparticlesClientNeoForge::suggestModId).executes(context -> {
            String modId = StringArgumentType.getString((CommandContext)context, (String)"modid");
            if (ModListHelper.isModLoaded(modId)) {
                String version = ModListHelper.versionToString(modId);
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)(modId + " version " + version)));
            } else {
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)(modId + " is not loaded")));
            }
            return 1;
        })).then(Commands.argument((String)"min_inclusive", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"max_exclusive", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String modId = StringArgumentType.getString((CommandContext)context, (String)"modid");
            String minInclusive = StringArgumentType.getString((CommandContext)context, (String)"min_inclusive");
            String maxExclusive = StringArgumentType.getString((CommandContext)context, (String)"max_exclusive");
            if (ModListHelper.isModLoaded(modId)) {
                boolean b = ModListHelper.versionCheck(modId, minInclusive, maxExclusive);
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)(modId + " version " + (b ? "is within" : "is not within") + " [" + minInclusive + ", " + maxExclusive + ")")));
            } else {
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)(modId + " is not loaded")));
            }
            return 1;
        })))))).then(Commands.literal((String)"reload").executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            try {
                SimplePropertiesConfig.load();
            }
            catch (IOException e) {
                source.sendSystemMessage((Component)Component.literal((String)"Failed to reload config"));
                return 1;
            }
            AsyncTicker.reloadLater();
            source.sendSystemMessage((Component)Component.literal((String)"AsyncParticles config reloaded"));
            return 1;
        })));
    }
}

